/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.spring.interceptor;

import org.apache.camel.Expression;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.builder.ValueBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.PolicyDefinition;
import org.apache.camel.spring.SpringRouteBuilder;
import org.apache.camel.spring.interceptor.TransactionClientDataSourceSupport;

public class TransactionalClientDataSourceTransactedWithFileOnExceptionTest
extends TransactionClientDataSourceSupport {
    public void testTransactionSuccess() throws Exception {
        this.template.sendBodyAndHeader("file://target/transacted/okay", (Object)"Hello World", "CamelFileName", (Object)"okay.txt");
        Thread.sleep(3000L);
        int count = this.jdbc.queryForInt("select count(*) from books");
        TransactionalClientDataSourceTransactedWithFileOnExceptionTest.assertEquals((String)"Number of books", (int)3, (int)count);
    }

    public void testTransactionRollback() throws Exception {
        MockEndpoint error = this.getMockEndpoint("mock:error");
        error.expectedMessageCount(1);
        ((ValueBuilder)error.message(0).header("CamelExceptionCaught")).isNotNull();
        ((ValueBuilder)error.message(0).header("CamelExceptionCaught")).isInstanceOf(IllegalArgumentException.class);
        error.expectedFileExists("target/transacted/failed/fail.txt");
        this.template.sendBodyAndHeader("file://target/transacted/fail", (Object)"Hello World", "CamelFileName", (Object)"fail.txt");
        Thread.sleep(3000L);
        int count = this.jdbc.queryForInt("select count(*) from books");
        TransactionalClientDataSourceTransactedWithFileOnExceptionTest.assertEquals((String)"Number of books", (int)1, (int)count);
        this.assertMockEndpointsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() throws Exception {
        return new SpringRouteBuilder(){

            public void configure() throws Exception {
                this.onException(IllegalArgumentException.class).handled(false).to("mock:error");
                ((PolicyDefinition)((PolicyDefinition)((PolicyDefinition)this.from("file://target/transacted/okay").transacted().setBody((Expression)this.constant("Tiger in Action"))).beanRef("bookService")).setBody((Expression)this.constant("Elephant in Action"))).beanRef("bookService");
                ((PolicyDefinition)((PolicyDefinition)((PolicyDefinition)this.from("file://target/transacted/fail?moveFailed=../failed").transacted().setBody((Expression)this.constant("Tiger in Action"))).beanRef("bookService")).setBody((Expression)this.constant("Donkey in Action"))).beanRef("bookService");
            }
        };
    }
}

