/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.spring.interceptor;

import org.apache.camel.Expression;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.PolicyDefinition;
import org.apache.camel.spring.SpringRouteBuilder;
import org.apache.camel.spring.interceptor.TransactionClientDataSourceSupport;

public class TransactionalClientDataSourceTransactedWithFileTest
extends TransactionClientDataSourceSupport {
    @Override
    protected void setUp() throws Exception {
        TransactionalClientDataSourceTransactedWithFileTest.deleteDirectory((String)"target/transacted");
        super.setUp();
    }

    public void testTransactionSuccess() throws Exception {
        this.template.sendBodyAndHeader("file://target/transacted/okay", (Object)"Hello World", "CamelFileName", (Object)"okay.txt");
        Thread.sleep(3000L);
        int count = this.jdbc.queryForInt("select count(*) from books");
        TransactionalClientDataSourceTransactedWithFileTest.assertEquals((String)"Number of books", (int)3, (int)count);
    }

    public void xxxtestTransactionRollback() throws Exception {
        this.template.sendBodyAndHeader("file://target/transacted/fail", (Object)"Hello World", "CamelFileName", (Object)"fail.txt");
        Thread.sleep(3000L);
        int count = this.jdbc.queryForInt("select count(*) from books");
        TransactionalClientDataSourceTransactedWithFileTest.assertEquals((String)"Number of books", (int)1, (int)count);
    }

    protected RouteBuilder createRouteBuilder() throws Exception {
        return new SpringRouteBuilder(){

            public void configure() throws Exception {
                ((PolicyDefinition)((PolicyDefinition)((PolicyDefinition)this.from("file://target/transacted/okay").transacted().setBody((Expression)this.constant("Tiger in Action"))).beanRef("bookService")).setBody((Expression)this.constant("Elephant in Action"))).beanRef("bookService");
                ((PolicyDefinition)((PolicyDefinition)((PolicyDefinition)this.from("file://target/transacted/fail?delay=1000").transacted().setBody((Expression)this.constant("Tiger in Action"))).beanRef("bookService")).setBody((Expression)this.constant("Donkey in Action"))).beanRef("bookService");
            }
        };
    }
}

