/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.spring.interceptor;

import org.apache.camel.CamelExecutionException;
import org.apache.camel.Expression;
import org.apache.camel.builder.ErrorHandlerBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.OnExceptionDefinition;
import org.apache.camel.model.PolicyDefinition;
import org.apache.camel.spi.Policy;
import org.apache.camel.spring.SpringRouteBuilder;
import org.apache.camel.spring.interceptor.TransactionalClientDataSourceTest;
import org.apache.camel.spring.spi.SpringTransactionPolicy;

public class TransactionalClientDataSourceWithOnExceptionHandledAndRollbackTest
extends TransactionalClientDataSourceTest {
    @Override
    protected int getExpectedRouteCount() {
        return 0;
    }

    @Override
    public void testTransactionRollback() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:error");
        mock.expectedMessageCount(1);
        try {
            this.template.requestBody("direct:fail", (Object)"Hello World", String.class);
            TransactionalClientDataSourceWithOnExceptionHandledAndRollbackTest.fail((String)"Should have thrown exception");
        }
        catch (CamelExecutionException e) {
            // empty catch block
        }
        this.assertMockEndpointsSatisfied();
        int count = this.jdbc.queryForInt("select count(*) from books");
        TransactionalClientDataSourceWithOnExceptionHandledAndRollbackTest.assertEquals((String)"Number of books", (int)1, (int)count);
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new SpringRouteBuilder(){

            public void configure() throws Exception {
                SpringTransactionPolicy required = (SpringTransactionPolicy)this.lookup("PROPAGATION_REQUIRED", SpringTransactionPolicy.class);
                this.errorHandler((ErrorHandlerBuilder)this.transactionErrorHandler(required));
                ((OnExceptionDefinition)this.onException(IllegalArgumentException.class).handled(true).to("mock:error")).rollback();
                ((PolicyDefinition)((PolicyDefinition)((PolicyDefinition)this.from("direct:okay").policy((Policy)required).setBody((Expression)this.constant("Tiger in Action"))).beanRef("bookService")).setBody((Expression)this.constant("Elephant in Action"))).beanRef("bookService");
                ((PolicyDefinition)((PolicyDefinition)((PolicyDefinition)this.from("direct:fail").policy((Policy)required).setBody((Expression)this.constant("Tiger in Action"))).beanRef("bookService")).setBody((Expression)this.constant("Donkey in Action"))).beanRef("bookService");
            }
        };
    }
}

