/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.spring.interceptor;

import org.apache.camel.Expression;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.OnExceptionDefinition;
import org.apache.camel.model.PolicyDefinition;
import org.apache.camel.spring.SpringRouteBuilder;
import org.apache.camel.spring.interceptor.TransactionalClientDataSourceTest;

public class TransactionalClientDataSourceWithOnExceptionHandledAndRollbackUsingTransactedTest
extends TransactionalClientDataSourceTest {
    @Override
    protected int getExpectedRouteCount() {
        return 0;
    }

    @Override
    public void testTransactionRollback() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:error");
        mock.expectedMessageCount(1);
        String out = (String)this.template.requestBody("direct:fail", (Object)"Hello World", String.class);
        TransactionalClientDataSourceWithOnExceptionHandledAndRollbackUsingTransactedTest.assertEquals((String)"Sorry", (String)out);
        this.assertMockEndpointsSatisfied();
        int count = this.jdbc.queryForInt("select count(*) from books");
        TransactionalClientDataSourceWithOnExceptionHandledAndRollbackUsingTransactedTest.assertEquals((String)"Number of books", (int)1, (int)count);
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new SpringRouteBuilder(){

            public void configure() throws Exception {
                ((OnExceptionDefinition)((OnExceptionDefinition)this.onException(IllegalArgumentException.class).handled(true).to("mock:error")).transform((Expression)this.constant("Sorry"))).markRollbackOnly();
                ((PolicyDefinition)((PolicyDefinition)((PolicyDefinition)this.from("direct:okay").transacted().setBody((Expression)this.constant("Tiger in Action"))).beanRef("bookService")).setBody((Expression)this.constant("Elephant in Action"))).beanRef("bookService");
                ((PolicyDefinition)((PolicyDefinition)((PolicyDefinition)this.from("direct:fail").transacted().setBody((Expression)this.constant("Tiger in Action"))).beanRef("bookService")).setBody((Expression)this.constant("Donkey in Action"))).beanRef("bookService");
            }
        };
    }
}

