/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.spring.interceptor;

import org.apache.camel.Expression;
import org.apache.camel.RollbackExchangeException;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.builder.ErrorHandlerBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.OnExceptionDefinition;
import org.apache.camel.model.PolicyDefinition;
import org.apache.camel.spi.Policy;
import org.apache.camel.spring.SpringRouteBuilder;
import org.apache.camel.spring.interceptor.TransactionalClientDataSourceTest;
import org.apache.camel.spring.spi.SpringTransactionPolicy;

public class TransactionalClientDataSourceWithOnExceptionRollbackTest
extends TransactionalClientDataSourceTest {
    @Override
    public void testTransactionRollback() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:error");
        mock.expectedMessageCount(1);
        try {
            this.template.sendBody("direct:fail", (Object)"Hello World");
        }
        catch (RuntimeCamelException e) {
            TransactionalClientDataSourceWithOnExceptionRollbackTest.assertIsInstanceOf(RuntimeCamelException.class, (Object)e.getCause());
            RollbackExchangeException rollback = (RollbackExchangeException)TransactionalClientDataSourceWithOnExceptionRollbackTest.assertIsInstanceOf(RollbackExchangeException.class, (Object)e.getCause().getCause());
            TransactionalClientDataSourceWithOnExceptionRollbackTest.assertEquals((Object)"Donkey in Action", (Object)rollback.getExchange().getIn().getBody());
        }
        this.assertMockEndpointsSatisfied();
        int count = this.jdbc.queryForInt("select count(*) from books");
        TransactionalClientDataSourceWithOnExceptionRollbackTest.assertEquals((String)"Number of books", (int)1, (int)count);
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new SpringRouteBuilder(){

            public void configure() throws Exception {
                SpringTransactionPolicy required = (SpringTransactionPolicy)this.lookup("PROPAGATION_REQUIRED", SpringTransactionPolicy.class);
                this.errorHandler((ErrorHandlerBuilder)this.transactionErrorHandler(required));
                ((OnExceptionDefinition)this.onException(IllegalArgumentException.class).handled(false).to("mock:error")).rollback();
                ((PolicyDefinition)((PolicyDefinition)((PolicyDefinition)this.from("direct:okay").policy((Policy)required).setBody((Expression)this.constant("Tiger in Action"))).beanRef("bookService")).setBody((Expression)this.constant("Elephant in Action"))).beanRef("bookService");
                ((PolicyDefinition)((PolicyDefinition)((PolicyDefinition)this.from("direct:fail").policy((Policy)required).setBody((Expression)this.constant("Tiger in Action"))).beanRef("bookService")).setBody((Expression)this.constant("Donkey in Action"))).beanRef("bookService");
            }
        };
    }
}

