/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.spring.interceptor;

import javax.sql.DataSource;
import org.apache.camel.Expression;
import org.apache.camel.RollbackExchangeException;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.builder.ErrorHandlerBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.PolicyDefinition;
import org.apache.camel.spi.Policy;
import org.apache.camel.spring.SpringRouteBuilder;
import org.apache.camel.spring.SpringTestSupport;
import org.apache.camel.spring.spi.SpringTransactionPolicy;
import org.springframework.context.support.AbstractXmlApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import org.springframework.jdbc.core.JdbcTemplate;

public class TransactionalClientWithRollbackTest
extends SpringTestSupport {
    protected JdbcTemplate jdbc;
    protected boolean useTransactionErrorHandler = true;

    @Override
    protected AbstractXmlApplicationContext createApplicationContext() {
        return new ClassPathXmlApplicationContext("/org/apache/camel/spring/interceptor/transactionalClientDataSource.xml");
    }

    @Override
    protected int getExpectedRouteCount() {
        return 0;
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        DataSource ds = this.getMandatoryBean(DataSource.class, "dataSource");
        this.jdbc = new JdbcTemplate(ds);
        this.jdbc.execute("create table books (title varchar(50))");
        this.jdbc.update("insert into books (title) values (?)", new Object[]{"Camel in Action"});
    }

    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
        this.jdbc.execute("drop table books");
    }

    public void testTransactionSuccess() throws Exception {
        this.template.sendBody("direct:okay", (Object)"Hello World");
        int count = this.jdbc.queryForInt("select count(*) from books");
        TransactionalClientWithRollbackTest.assertEquals((String)"Number of books", (int)3, (int)count);
    }

    public void testTransactionRollback() throws Exception {
        try {
            this.template.sendBody("direct:fail", (Object)"Hello World");
            TransactionalClientWithRollbackTest.fail((String)"Should have thrown a RollbackExchangeException");
        }
        catch (RuntimeCamelException e) {
            TransactionalClientWithRollbackTest.assertIsInstanceOf(RuntimeCamelException.class, (Object)e.getCause());
            TransactionalClientWithRollbackTest.assertTrue((boolean)(e.getCause().getCause() instanceof RollbackExchangeException));
        }
        int count = this.jdbc.queryForInt("select count(*) from books");
        TransactionalClientWithRollbackTest.assertEquals((String)"Number of books", (int)1, (int)count);
    }

    protected RouteBuilder createRouteBuilder() throws Exception {
        return new SpringRouteBuilder(){

            public void configure() throws Exception {
                SpringTransactionPolicy required = (SpringTransactionPolicy)this.lookup("PROPAGATION_REQUIRED", SpringTransactionPolicy.class);
                this.errorHandler((ErrorHandlerBuilder)this.transactionErrorHandler(required));
                ((PolicyDefinition)((PolicyDefinition)((PolicyDefinition)this.from("direct:okay").policy((Policy)required).setBody((Expression)this.constant("Tiger in Action"))).beanRef("bookService")).setBody((Expression)this.constant("Elephant in Action"))).beanRef("bookService");
                ((PolicyDefinition)((PolicyDefinition)this.from("direct:fail").policy((Policy)required).setBody((Expression)this.constant("Tiger in Action"))).beanRef("bookService")).rollback();
            }
        };
    }
}

