/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.spring.issues;

import org.apache.camel.Exchange;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.spring.SpringTestSupport;
import org.springframework.context.support.AbstractXmlApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public class FileWireTapWithXMLPayloadIssueTest
extends SpringTestSupport {
    @Override
    protected void setUp() throws Exception {
        FileWireTapWithXMLPayloadIssueTest.deleteDirectory((String)"target/xmldata");
        super.setUp();
        this.template.sendBodyAndHeader("file://target/xmldata", (Object)"<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<sample>\n<test>Helloooo</test>\n</sample>", "CamelFileName", (Object)"hello.xml");
    }

    public void testWireTapXpathExpression() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(1);
        MockEndpoint tap = this.getMockEndpoint("mock:wiretap");
        tap.expectedMessageCount(1);
        this.assertMockEndpointsSatisfied();
        String dataResult = (String)((Exchange)mock.getReceivedExchanges().get(0)).getIn().getBody(String.class);
        String dataTap = (String)((Exchange)tap.getReceivedExchanges().get(0)).getIn().getBody(String.class);
        FileWireTapWithXMLPayloadIssueTest.assertEquals((String)dataResult, (String)dataTap);
    }

    @Override
    protected AbstractXmlApplicationContext createApplicationContext() {
        return new ClassPathXmlApplicationContext("org/apache/camel/spring/issues/FileWireTapWithXMLPayloadIssueTest.xml");
    }
}

