/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.spring.issues;

import javax.sql.DataSource;
import org.apache.camel.CamelExecutionException;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.spring.SpringTestSupport;
import org.springframework.context.support.AbstractXmlApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import org.springframework.jdbc.core.JdbcTemplate;

public class SpringTransactionErrorHandlerAndContextScopedOnExceptionIssueTest
extends SpringTestSupport {
    protected JdbcTemplate jdbc;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        DataSource ds = this.getMandatoryBean(DataSource.class, "dataSource");
        this.jdbc = new JdbcTemplate(ds);
        this.jdbc.execute("create table books (title varchar(50))");
    }

    @Override
    protected void tearDown() throws Exception {
        this.jdbc.execute("drop table books");
        super.tearDown();
    }

    @Override
    protected AbstractXmlApplicationContext createApplicationContext() {
        return new ClassPathXmlApplicationContext("org/apache/camel/spring/issues/SpringTransactionErrorHandlerAndContextScopedOnExceptionIssueTest.xml");
    }

    public void testSpringTXOnExceptionIssueCommit() throws Exception {
        int count = this.jdbc.queryForInt("select count(*) from books");
        SpringTransactionErrorHandlerAndContextScopedOnExceptionIssueTest.assertEquals((String)"Number of books", (int)0, (int)count);
        this.getMockEndpoint("mock:onException").expectedMessageCount(0);
        this.getMockEndpoint("mock:result").expectedMessageCount(1);
        this.template.sendBody("direct:start", (Object)"Camel in Action");
        this.assertMockEndpointsSatisfied();
        count = this.jdbc.queryForInt("select count(*) from books");
        SpringTransactionErrorHandlerAndContextScopedOnExceptionIssueTest.assertEquals((String)"Number of books", (int)1, (int)count);
    }

    public void testSpringTXOnExceptionIssueRollback() throws Exception {
        int count = this.jdbc.queryForInt("select count(*) from books");
        SpringTransactionErrorHandlerAndContextScopedOnExceptionIssueTest.assertEquals((String)"Number of books", (int)0, (int)count);
        this.getMockEndpoint("mock:onException").expectedMessageCount(1);
        this.getMockEndpoint("mock:result").expectedMessageCount(0);
        try {
            this.template.sendBody("direct:start", (Object)"Donkey in Action");
            SpringTransactionErrorHandlerAndContextScopedOnExceptionIssueTest.fail((String)"Should have thrown exception");
        }
        catch (CamelExecutionException e) {
            SpringTransactionErrorHandlerAndContextScopedOnExceptionIssueTest.assertIsInstanceOf(RuntimeCamelException.class, (Object)e.getCause());
            SpringTransactionErrorHandlerAndContextScopedOnExceptionIssueTest.assertIsInstanceOf(IllegalArgumentException.class, (Object)e.getCause().getCause());
            SpringTransactionErrorHandlerAndContextScopedOnExceptionIssueTest.assertEquals((String)"We don't have Donkeys, only Camels", (String)e.getCause().getCause().getMessage());
        }
        this.assertMockEndpointsSatisfied();
        count = this.jdbc.queryForInt("select count(*) from books");
        SpringTransactionErrorHandlerAndContextScopedOnExceptionIssueTest.assertEquals((String)"Number of books", (int)0, (int)count);
    }
}

