/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.spring.issues;

import org.apache.camel.CamelContext;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.spring.processor.SpringTestHelper;

public class SpringTryCatchFinallyAndErrorHandlerTest
extends ContextTestSupport {
    protected CamelContext createCamelContext() throws Exception {
        return SpringTestHelper.createSpringCamelContext(this, "org/apache/camel/spring/issues/SpringTryCatchFinallyAndErrorHandlerTest.xml");
    }

    public void testOk() throws Exception {
        this.getMockEndpoint("mock:bar").expectedMessageCount(1);
        this.getMockEndpoint("mock:donkey").expectedMessageCount(0);
        this.getMockEndpoint("mock:catch").expectedMessageCount(0);
        this.getMockEndpoint("mock:finally").expectedMessageCount(1);
        this.getMockEndpoint("mock:kong").expectedMessageCount(0);
        this.getMockEndpoint("mock:other").expectedMessageCount(1);
        this.getMockEndpoint("mock:end").expectedMessageCount(1);
        this.getMockEndpoint("mock:dead").expectedMessageCount(0);
        this.template.sendBody("direct:start", (Object)"Hello Camel");
        this.assertMockEndpointsSatisfied();
    }

    public void testFail() throws Exception {
        this.getMockEndpoint("mock:bar").expectedMessageCount(0);
        this.getMockEndpoint("mock:donkey").expectedMessageCount(1);
        this.getMockEndpoint("mock:catch").expectedMessageCount(1);
        this.getMockEndpoint("mock:finally").expectedMessageCount(1);
        this.getMockEndpoint("mock:kong").expectedMessageCount(0);
        this.getMockEndpoint("mock:other").expectedMessageCount(1);
        this.getMockEndpoint("mock:end").expectedMessageCount(1);
        this.getMockEndpoint("mock:dead").expectedMessageCount(0);
        this.template.sendBody("direct:start", (Object)"Hello Donkey");
        this.assertMockEndpointsSatisfied();
    }

    public void testFailAgain() throws Exception {
        this.getMockEndpoint("mock:bar").expectedMessageCount(0);
        this.getMockEndpoint("mock:donkey").expectedMessageCount(1);
        this.getMockEndpoint("mock:catch").expectedMessageCount(1);
        this.getMockEndpoint("mock:finally").expectedMessageCount(1);
        this.getMockEndpoint("mock:kong").expectedMessageCount(1);
        this.getMockEndpoint("mock:other").expectedMessageCount(0);
        this.getMockEndpoint("mock:end").expectedMessageCount(0);
        this.getMockEndpoint("mock:dead").expectedMessageCount(1);
        this.template.sendBody("direct:start", (Object)"Donkey Kong");
        this.assertMockEndpointsSatisfied();
    }
}

