/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.spring.issues;

import junit.framework.TestCase;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.component.mock.MockEndpoint;
import org.springframework.context.support.AbstractXmlApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public class SpringTwoCamelContextDirectEndpointTest
extends TestCase {
    protected AbstractXmlApplicationContext createApplicationContext() {
        return new ClassPathXmlApplicationContext("org/apache/camel/spring/issues/SpringTwoCamelContextDirectEndpointTest.xml");
    }

    public void testSpringTwoCamelContextDirectEndpoint() throws Exception {
        AbstractXmlApplicationContext ac = this.createApplicationContext();
        ac.start();
        CamelContext camel1 = (CamelContext)ac.getBean("camel-1", CamelContext.class);
        CamelContext camel2 = (CamelContext)ac.getBean("camel-2", CamelContext.class);
        Endpoint start1 = camel1.getEndpoint("direct:start");
        Endpoint start2 = camel2.getEndpoint("direct:start");
        SpringTwoCamelContextDirectEndpointTest.assertNotSame((Object)start1, (Object)start2);
        Endpoint foo1 = camel1.getEndpoint("direct:foo");
        Endpoint foo2 = camel2.getEndpoint("direct:foo");
        SpringTwoCamelContextDirectEndpointTest.assertNotSame((Object)foo1, (Object)foo2);
        MockEndpoint mock1 = (MockEndpoint)camel1.getEndpoint("mock:a", MockEndpoint.class);
        mock1.expectedBodiesReceived(new Object[]{"Hello World"});
        MockEndpoint mock2 = (MockEndpoint)camel2.getEndpoint("mock:b", MockEndpoint.class);
        mock2.expectedBodiesReceived(new Object[]{"Bye World"});
        camel1.createProducerTemplate().sendBody("direct:start", (Object)"Hello World");
        camel2.createProducerTemplate().sendBody("direct:start", (Object)"Bye World");
        mock1.assertIsSatisfied();
        mock2.assertIsSatisfied();
        ac.stop();
    }
}

