/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.spring.issues;

import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.spring.SpringTestSupport;
import org.springframework.context.support.AbstractXmlApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public class StringDataFormatTest
extends SpringTestSupport {
    @Override
    protected AbstractXmlApplicationContext createApplicationContext() {
        return new ClassPathXmlApplicationContext("org/apache/camel/spring/issues/stringDataFormatTest.xml");
    }

    public void testMarshalString() throws Exception {
        String body = "Hello Thai Elephant \u0e08";
        MockEndpoint mock = this.getMockEndpoint("mock:marshal");
        mock.expectedMessageCount(1);
        byte[] out = (byte[])this.template.requestBody("direct:marshal", (Object)body);
        this.assertMockEndpointsSatisfied();
        String result = new String(out, "UTF-8");
        StringDataFormatTest.assertEquals((String)body, (String)result);
    }

    public void testUnMarshalString() throws Exception {
        byte[] body = "Hello Thai Elephant \u0e08".getBytes();
        MockEndpoint mock = this.getMockEndpoint("mock:unmarshal");
        mock.expectedMessageCount(1);
        String out = (String)this.template.requestBody("direct:unmarshal", (Object)body);
        this.assertMockEndpointsSatisfied();
        StringDataFormatTest.assertEquals((String)new String(body, "UTF-8"), (String)out);
    }
}

