/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.spring.management;

import java.util.Iterator;
import java.util.Set;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.camel.spring.management.DualCamelContextManagedTest;
import org.springframework.context.support.AbstractXmlApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public class DualCamelContextManagedAutoAssignedNameTest
extends DualCamelContextManagedTest {
    @Override
    protected AbstractXmlApplicationContext createApplicationContext() {
        return new ClassPathXmlApplicationContext("org/apache/camel/spring/management/dualCamelContextManagedAutoAssignedNameTest.xml");
    }

    @Override
    public void testDualCamelContextManaged() throws Exception {
        MBeanServer mbeanServer = this.context.getManagementStrategy().getManagementAgent().getMBeanServer();
        Set<ObjectName> set = mbeanServer.queryNames(new ObjectName("*:type=routes,*"), null);
        DualCamelContextManagedAutoAssignedNameTest.assertEquals((int)2, (int)set.size());
        Iterator<ObjectName> it = set.iterator();
        ObjectName on1 = it.next();
        ObjectName on2 = it.next();
        DualCamelContextManagedAutoAssignedNameTest.assertTrue((String)"Route 1 is missing", (on1.getCanonicalName().contains("route1") || on2.getCanonicalName().contains("route1") ? 1 : 0) != 0);
        DualCamelContextManagedAutoAssignedNameTest.assertTrue((String)"Route 2 is missing", (on1.getCanonicalName().contains("route2") || on2.getCanonicalName().contains("route2") ? 1 : 0) != 0);
        set = mbeanServer.queryNames(new ObjectName("*:type=endpoints,*"), null);
        DualCamelContextManagedAutoAssignedNameTest.assertTrue((String)("Size should be 7 or higher, was: " + set.size()), (set.size() >= 7 ? 1 : 0) != 0);
        for (ObjectName on : set) {
            String id;
            String name = on.getCanonicalName();
            if (name.contains("mock://mock1")) {
                id = (String)mbeanServer.getAttribute(on, "CamelId");
                DualCamelContextManagedAutoAssignedNameTest.assertEquals((String)"camel-1", (String)id);
                continue;
            }
            if (name.contains("mock://mock2")) {
                id = (String)mbeanServer.getAttribute(on, "CamelId");
                DualCamelContextManagedAutoAssignedNameTest.assertEquals((String)"camel-2", (String)id);
                continue;
            }
            if (name.contains("file://target/route1")) {
                id = (String)mbeanServer.getAttribute(on, "CamelId");
                DualCamelContextManagedAutoAssignedNameTest.assertEquals((String)"camel-1", (String)id);
                continue;
            }
            if (!name.contains("file://target/route2")) continue;
            id = (String)mbeanServer.getAttribute(on, "CamelId");
            DualCamelContextManagedAutoAssignedNameTest.assertEquals((String)"camel-2", (String)id);
        }
    }
}

