/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.spring.management;

import java.util.Set;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.camel.spring.SpringTestSupport;
import org.springframework.context.support.AbstractXmlApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public class DualCamelContextManagedTest
extends SpringTestSupport {
    protected boolean useJmx() {
        return true;
    }

    @Override
    protected int getExpectedRouteCount() {
        return 0;
    }

    @Override
    protected AbstractXmlApplicationContext createApplicationContext() {
        return new ClassPathXmlApplicationContext("org/apache/camel/spring/management/dualCamelContextManagedTest.xml");
    }

    public void testDualCamelContextManaged() throws Exception {
        MBeanServer mbeanServer = this.context.getManagementStrategy().getManagementAgent().getMBeanServer();
        ObjectName on1 = null;
        ObjectName on2 = null;
        Set<ObjectName> set = mbeanServer.queryNames(new ObjectName("*:type=routes,*"), null);
        for (ObjectName on : set) {
            if (on.getCanonicalName().contains("camel-A")) {
                on1 = on;
                continue;
            }
            if (!on.getCanonicalName().contains("camel-B")) continue;
            on2 = on;
        }
        DualCamelContextManagedTest.assertNotNull((String)"Should have found camel-A route", on1);
        DualCamelContextManagedTest.assertNotNull((String)"Should have found camel-B route", on2);
        DualCamelContextManagedTest.assertTrue((String)"Route 1 is missing", (boolean)on1.getCanonicalName().contains("route1"));
        DualCamelContextManagedTest.assertTrue((String)"Route 2 is missing", (boolean)on2.getCanonicalName().contains("route2"));
        set = mbeanServer.queryNames(new ObjectName("*:type=endpoints,*"), null);
        DualCamelContextManagedTest.assertTrue((String)("Should be at least 7 endpoints, was: " + set.size()), (set.size() >= 7 ? 1 : 0) != 0);
        for (ObjectName on : set) {
            String id;
            String name = on.getCanonicalName();
            if (name.contains("mock://mock1")) {
                id = (String)mbeanServer.getAttribute(on, "CamelId");
                DualCamelContextManagedTest.assertEquals((String)"camel-A", (String)id);
                continue;
            }
            if (name.contains("mock://mock2")) {
                id = (String)mbeanServer.getAttribute(on, "CamelId");
                DualCamelContextManagedTest.assertEquals((String)"camel-B", (String)id);
                continue;
            }
            if (name.contains("file://target/route1")) {
                id = (String)mbeanServer.getAttribute(on, "CamelId");
                DualCamelContextManagedTest.assertEquals((String)"camel-A", (String)id);
                continue;
            }
            if (!name.contains("file://target/route2")) continue;
            id = (String)mbeanServer.getAttribute(on, "CamelId");
            DualCamelContextManagedTest.assertEquals((String)"camel-B", (String)id);
        }
    }
}

