/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.spring.management;

import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.camel.spring.SpringTestSupport;
import org.springframework.context.support.AbstractXmlApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public class SpringJmxDumpRoutesAsXmlTest
extends SpringTestSupport {
    @Override
    protected AbstractXmlApplicationContext createApplicationContext() {
        return new ClassPathXmlApplicationContext("org/apache/camel/spring/management/SpringJmxDumpRouteAsXmlTest.xml");
    }

    protected MBeanServer getMBeanServer() {
        return this.context.getManagementStrategy().getManagementAgent().getMBeanServer();
    }

    public void testJmxDumpRoutesAsXml() throws Exception {
        MBeanServer mbeanServer = this.getMBeanServer();
        ObjectName on = ObjectName.getInstance("org.apache.camel:context=localhost/camel-1,type=context,name=\"camel-1\"");
        String xml = (String)mbeanServer.invoke(on, "dumpRoutesAsXml", null, null);
        SpringJmxDumpRoutesAsXmlTest.assertNotNull((Object)xml);
        this.log.info(xml);
        SpringJmxDumpRoutesAsXmlTest.assertTrue((boolean)xml.contains("route"));
        SpringJmxDumpRoutesAsXmlTest.assertTrue((boolean)xml.contains("myRoute"));
        SpringJmxDumpRoutesAsXmlTest.assertTrue((boolean)xml.contains("myOtherRoute"));
        SpringJmxDumpRoutesAsXmlTest.assertTrue((boolean)xml.contains("direct:start"));
        SpringJmxDumpRoutesAsXmlTest.assertTrue((boolean)xml.contains("mock:result"));
        SpringJmxDumpRoutesAsXmlTest.assertTrue((boolean)xml.contains("seda:bar"));
        SpringJmxDumpRoutesAsXmlTest.assertTrue((boolean)xml.contains("mock:bar"));
    }
}

