/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.spring.management;

import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.spring.SpringTestSupport;
import org.springframework.context.support.AbstractXmlApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public class SpringJmxRecipientListTest
extends SpringTestSupport {
    @Override
    protected AbstractXmlApplicationContext createApplicationContext() {
        return new ClassPathXmlApplicationContext("org/apache/camel/spring/management/SpringJmxRecipientListTest.xml");
    }

    protected MBeanServer getMBeanServer() {
        return this.context.getManagementStrategy().getManagementAgent().getMBeanServer();
    }

    public void testJmxEndpointsAddedDynamicallyDefaultRegister() throws Exception {
        MockEndpoint x = this.getMockEndpoint("mock:x");
        MockEndpoint y = this.getMockEndpoint("mock:y");
        MockEndpoint z = this.getMockEndpoint("mock:z");
        x.expectedBodiesReceived(new Object[]{"answer"});
        y.expectedBodiesReceived(new Object[]{"answer"});
        z.expectedBodiesReceived(new Object[]{"answer"});
        this.template.sendBodyAndHeader("direct:a", (Object)"answer", "recipientListHeader", (Object)"mock:x,mock:y,mock:z");
        this.assertMockEndpointsSatisfied();
        MBeanServer mbeanServer = this.getMBeanServer();
        ObjectName name = ObjectName.getInstance("org.apache.camel:context=localhost/camel-1,type=endpoints,name=\"direct://a\"");
        SpringJmxRecipientListTest.assertTrue((String)"Should be registered", (boolean)mbeanServer.isRegistered(name));
        name = ObjectName.getInstance("org.apache.camel:context=localhost/camel-1,type=endpoints,name=\"mock://x\"");
        SpringJmxRecipientListTest.assertFalse((String)"Should not be registered", (boolean)mbeanServer.isRegistered(name));
        name = ObjectName.getInstance("org.apache.camel:context=localhost/camel-1,type=endpoints,name=\"mock://y\"");
        SpringJmxRecipientListTest.assertFalse((String)"Should not be registered", (boolean)mbeanServer.isRegistered(name));
        name = ObjectName.getInstance("org.apache.camel:context=localhost/camel-1,type=endpoints,name=\"mock://z\"");
        SpringJmxRecipientListTest.assertFalse((String)"Should not be registered", (boolean)mbeanServer.isRegistered(name));
        name = ObjectName.getInstance("org.apache.camel:context=localhost/camel-1,type=components,name=\"mock\"");
        SpringJmxRecipientListTest.assertTrue((String)"Should be registered", (boolean)mbeanServer.isRegistered(name));
    }
}

