/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.spring.patterns;

import org.apache.camel.EndpointInject;
import org.apache.camel.Produce;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.component.mock.MockEndpoint;
import org.springframework.test.annotation.DirtiesContext;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit38.AbstractJUnit38SpringContextTests;

@ContextConfiguration
public class FilterTest
extends AbstractJUnit38SpringContextTests {
    @EndpointInject(uri="mock:result")
    protected MockEndpoint resultEndpoint;
    @Produce(uri="direct:start")
    protected ProducerTemplate template;

    @DirtiesContext
    public void testSendMatchingMessage() throws Exception {
        String expectedBody = "<matched/>";
        this.resultEndpoint.expectedBodiesReceived(new Object[]{expectedBody});
        this.template.sendBodyAndHeader((Object)expectedBody, "foo", (Object)"bar");
        this.resultEndpoint.assertIsSatisfied();
    }

    @DirtiesContext
    public void testSendNotMatchingMessage() throws Exception {
        this.resultEndpoint.expectedMessageCount(0);
        this.template.sendBodyAndHeader((Object)"<notMatched/>", "foo", (Object)"notMatchedHeaderValue");
        this.resultEndpoint.assertIsSatisfied();
    }
}

