/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.spring.placeholder;

import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Produce;
import org.apache.camel.ProducerTemplate;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.springframework.test.annotation.DirtiesContext;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.AbstractJUnit4SpringContextTests;

@ContextConfiguration
public class SimpleLanguageWithSprinPropertyPlaceholderRouteTest
extends AbstractJUnit4SpringContextTests {
    @Produce(uri="direct:startSimple")
    protected ProducerTemplate template;

    @Before
    public void setUp() throws Exception {
        ContextTestSupport.deleteDirectory((String)"target/outBox");
        ContextTestSupport.deleteDirectory((String)"target/outBoxSimple");
    }

    @Test
    @DirtiesContext
    public void replaceSimpleExpression() throws Exception {
        this.template.sendBody((Object)"Test");
        Thread.sleep(500L);
        this.assertFileExists("target/outBoxSimple/");
    }

    @Ignore(value="dissabled because of https://jira.springsource.org/browse/SPR-7593")
    @Test
    @DirtiesContext
    public void replaceExpression() throws Exception {
        this.template.sendBody("direct:start", (Object)"Test");
        Thread.sleep(500L);
        this.assertFileExists("target/outBox/" + this.getTestFileName());
    }

    private String getTestFileName() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
        String s = sdf.format(new Date());
        return "test-" + s + ".txt";
    }

    private void assertFileExists(String filename) {
        File file = new File(filename).getAbsoluteFile();
        Assert.assertTrue((String)("File " + filename + " should exist"), (boolean)file.exists());
    }
}

