/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.spring.postprocessor;

import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.spring.SpringTestSupport;
import org.apache.camel.spring.postprocessor.TestPojo;
import org.springframework.context.support.AbstractXmlApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public class CamelCustomPostProcessorOnRouteBuilderTest
extends SpringTestSupport {
    @Override
    protected AbstractXmlApplicationContext createApplicationContext() {
        return new ClassPathXmlApplicationContext("org/apache/camel/spring/postprocessor/camelCustomPostProcessorOnRouteBuilderTest.xml");
    }

    public void testShouldProcessAnnotatedFields() throws Exception {
        this.getMockEndpoint("mock:injected").expectedMessageCount(1);
        this.getMockEndpoint("mock:result").expectedMessageCount(1);
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
        TestPojo pojo = (TestPojo)this.context.getRegistry().lookup("testPojo");
        CamelCustomPostProcessorOnRouteBuilderTest.assertNotNull((String)"Test pojo not registered", (Object)pojo);
        CamelCustomPostProcessorOnRouteBuilderTest.assertEquals((String)"Processor has not changed field value", (String)"Changed Value", (String)pojo.getTestValue());
        MockEndpoint foo = this.getMockEndpoint("mock:foo");
        foo.expectedBodiesReceived(new Object[]{"Hi"});
        pojo.sendToFoo("Hi");
        foo.assertIsSatisfied();
    }
}

