/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.spring.postprocessor;

import java.lang.reflect.Field;
import org.apache.camel.spring.postprocessor.MagicAnnotation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.InstantiationAwareBeanPostProcessorAdapter;
import org.springframework.stereotype.Component;
import org.springframework.util.ReflectionUtils;

@Component
public class MagicAnnotationPostProcessor
extends InstantiationAwareBeanPostProcessorAdapter {
    protected Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());

    public boolean postProcessAfterInstantiation(final Object bean, String beanName) throws BeansException {
        ReflectionUtils.doWithFields(bean.getClass(), (ReflectionUtils.FieldCallback)new ReflectionUtils.FieldCallback(){

            public void doWith(Field field) throws IllegalArgumentException, IllegalAccessException {
                MagicAnnotation annotation = field.getAnnotation(MagicAnnotation.class);
                if (annotation != null && field.getType() == String.class) {
                    MagicAnnotationPostProcessor.this.log.info("Found MagicAnnotation on field " + field + " of class " + bean.getClass());
                    ReflectionUtils.makeAccessible((Field)field);
                    field.set(bean, annotation.value());
                }
            }
        });
        return true;
    }
}

