/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.spring.processor;

import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.camel.spring.SpringTestSupport;
import org.springframework.context.support.AbstractXmlApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public class DualSpringManagedThreadsThreadPoolTest
extends SpringTestSupport {
    @Override
    protected AbstractXmlApplicationContext createApplicationContext() {
        return new ClassPathXmlApplicationContext("org/apache/camel/spring/processor/SpringDualManagedThreadsThreadPoolTest.xml");
    }

    public void testDualManagedThreadPool() throws Exception {
        MBeanServer mbeanServer = this.context.getManagementStrategy().getManagementAgent().getMBeanServer();
        ObjectName on = ObjectName.getInstance("org.apache.camel:context=localhost/camel-1,type=threadpools,name=\"myPool\"");
        Integer corePoolSize = (Integer)mbeanServer.getAttribute(on, "CorePoolSize");
        DualSpringManagedThreadsThreadPoolTest.assertEquals((int)2, (int)corePoolSize);
        Integer maxPoolSize = (Integer)mbeanServer.getAttribute(on, "MaximumPoolSize");
        DualSpringManagedThreadsThreadPoolTest.assertEquals((int)4, (int)maxPoolSize);
        this.getMockEndpoint("mock:result").expectedMessageCount(1);
        this.getMockEndpoint("mock:foo").expectedMessageCount(1);
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.template.sendBody("direct:foo", (Object)"Bye World");
        this.assertMockEndpointsSatisfied();
        String id = (String)mbeanServer.getAttribute(on, "Id");
        DualSpringManagedThreadsThreadPoolTest.assertEquals((String)"myPool", (String)id);
        String source = (String)mbeanServer.getAttribute(on, "SourceId");
        DualSpringManagedThreadsThreadPoolTest.assertEquals(null, (String)source);
        String routeId = (String)mbeanServer.getAttribute(on, "RouteId");
        DualSpringManagedThreadsThreadPoolTest.assertEquals(null, (String)routeId);
        on = ObjectName.getInstance("org.apache.camel:context=localhost/camel-1,type=threadpools,name=\"myOtherPool\"");
        corePoolSize = (Integer)mbeanServer.getAttribute(on, "CorePoolSize");
        DualSpringManagedThreadsThreadPoolTest.assertEquals((int)7, (int)corePoolSize);
        maxPoolSize = (Integer)mbeanServer.getAttribute(on, "MaximumPoolSize");
        DualSpringManagedThreadsThreadPoolTest.assertEquals((int)9, (int)maxPoolSize);
        id = (String)mbeanServer.getAttribute(on, "Id");
        DualSpringManagedThreadsThreadPoolTest.assertEquals((String)"myOtherPool", (String)id);
        source = (String)mbeanServer.getAttribute(on, "SourceId");
        DualSpringManagedThreadsThreadPoolTest.assertEquals(null, (String)source);
        routeId = (String)mbeanServer.getAttribute(on, "RouteId");
        DualSpringManagedThreadsThreadPoolTest.assertEquals(null, (String)routeId);
    }
}

