/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.spring.processor;

import org.apache.camel.CamelContext;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.processor.aggregate.AggregationStrategy;
import org.apache.camel.spring.processor.SpringTestHelper;

public class SpringComplexBlockWithEndTest
extends ContextTestSupport {
    public void testHello() throws Exception {
        this.getMockEndpoint("mock:hello").expectedMessageCount(1);
        this.getMockEndpoint("mock:bye").expectedMessageCount(0);
        this.getMockEndpoint("mock:otherwise").expectedMessageCount(0);
        this.getMockEndpoint("mock:result").expectedMessageCount(1);
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
    }

    public void testBye() throws Exception {
        this.getMockEndpoint("mock:hello").expectedMessageCount(0);
        this.getMockEndpoint("mock:bye").expectedMessageCount(1);
        this.getMockEndpoint("mock:otherwise").expectedMessageCount(0);
        this.getMockEndpoint("mock:result").expectedMessageCount(1);
        this.template.sendBody("direct:start", (Object)"Bye World");
        this.assertMockEndpointsSatisfied();
    }

    public void testOther() throws Exception {
        this.getMockEndpoint("mock:hello").expectedMessageCount(0);
        this.getMockEndpoint("mock:bye").expectedMessageCount(0);
        this.getMockEndpoint("mock:otherwise").expectedMessageCount(1);
        this.getMockEndpoint("mock:trapped").expectedMessageCount(1);
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"Cowboys"});
        this.getMockEndpoint("mock:split").expectedBodiesReceived(new Object[]{"Hi The good", "Hi The ugly"});
        this.template.sendBody("direct:start", (Object)"The good,The bad,The ugly");
        this.assertMockEndpointsSatisfied();
    }

    protected CamelContext createCamelContext() throws Exception {
        return SpringTestHelper.createSpringCamelContext(this, "org/apache/camel/spring/processor/SpringComplexBlockWithEndTest.xml");
    }

    public static class SplitAggregate
    implements AggregationStrategy {
        public Exchange aggregate(Exchange oldExchange, Exchange newExchange) {
            newExchange.getOut().setBody((Object)"Cowboys");
            return newExchange;
        }
    }
}

