/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.spring.processor;

import org.apache.camel.Exchange;
import org.apache.camel.impl.ExpressionAdapter;
import org.apache.camel.spring.SpringTestSupport;
import org.springframework.context.support.AbstractXmlApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public class SpringCustomExpressionTest
extends SpringTestSupport {
    public void testTransformMyExpression() throws InterruptedException {
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"Yes Camel rocks", "Hello World"});
        this.template.sendBody("direct:start", (Object)"Camel");
        this.template.sendBody("direct:start", (Object)"World");
        this.assertMockEndpointsSatisfied();
    }

    @Override
    protected AbstractXmlApplicationContext createApplicationContext() {
        return new ClassPathXmlApplicationContext("org/apache/camel/spring/processor/SpringCustomExpressionTest.xml");
    }

    public static class MyExpression
    extends ExpressionAdapter {
        public Object evaluate(Exchange exchange) {
            String body = (String)exchange.getIn().getBody(String.class);
            if (body.contains("Camel")) {
                return "Yes Camel rocks";
            }
            return "Hello " + body;
        }
    }
}

