/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.spring.processor;

import org.apache.camel.Exchange;
import org.apache.camel.Predicate;
import org.apache.camel.spring.SpringTestSupport;
import org.springframework.context.support.AbstractXmlApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public class SpringCustomPredicateTest
extends SpringTestSupport {
    public void testFilterMyPredicate() throws InterruptedException {
        this.getMockEndpoint("mock:foo").expectedBodiesReceived(new Object[]{"Hello Camel", "Secret Agent"});
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"Hello Camel", "Hello World", "Secret Agent"});
        this.template.sendBody("direct:start", (Object)"Hello Camel");
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.template.sendBody("direct:start", (Object)"Secret Agent");
        this.assertMockEndpointsSatisfied();
    }

    @Override
    protected AbstractXmlApplicationContext createApplicationContext() {
        return new ClassPathXmlApplicationContext("org/apache/camel/spring/processor/SpringCustomPredicateTest.xml");
    }

    public static class MyPredicate
    implements Predicate {
        public boolean matches(Exchange exchange) {
            String body = (String)exchange.getIn().getBody(String.class);
            if (body.contains("Camel")) {
                return true;
            }
            return body.startsWith("Secret");
        }
    }
}

