/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.spring.processor;

import org.apache.camel.CamelExecutionException;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.spring.SpringTestSupport;
import org.springframework.context.support.AbstractXmlApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public class SpringDefaultErrorHandlerNotHandledPolicyTest
extends SpringTestSupport {
    @Override
    protected AbstractXmlApplicationContext createApplicationContext() {
        return new ClassPathXmlApplicationContext("org/apache/camel/spring/processor/SpringDefaultErrorHandlerNotHandledPolicyTest.xml");
    }

    public void testNotHandled() throws Exception {
        try {
            this.template.sendBody("direct:start", (Object)"Hello World");
            SpringDefaultErrorHandlerNotHandledPolicyTest.fail((String)"Should have thrown an exception");
        }
        catch (CamelExecutionException e) {
            SpringDefaultErrorHandlerNotHandledPolicyTest.assertIsInstanceOf(IllegalArgumentException.class, (Object)e.getCause());
            SpringDefaultErrorHandlerNotHandledPolicyTest.assertEquals((String)"Forced", (String)e.getCause().getMessage());
        }
    }

    public void testNotHandledSendExchange() throws Exception {
        Exchange out = this.template.send("direct:start", new Processor(){

            public void process(Exchange exchange) throws Exception {
                exchange.getIn().setBody((Object)"Hello World");
            }
        });
        Exception e = out.getException();
        SpringDefaultErrorHandlerNotHandledPolicyTest.assertNotNull((String)"Should have thrown an exception", (Object)e);
        SpringDefaultErrorHandlerNotHandledPolicyTest.assertIsInstanceOf(IllegalArgumentException.class, (Object)e);
        SpringDefaultErrorHandlerNotHandledPolicyTest.assertEquals((String)"Forced", (String)e.getMessage());
        SpringDefaultErrorHandlerNotHandledPolicyTest.assertEquals((Object)true, (Object)out.getIn().getHeader("CamelRedelivered"));
        SpringDefaultErrorHandlerNotHandledPolicyTest.assertEquals((Object)2, (Object)out.getIn().getHeader("CamelRedeliveryCounter"));
        SpringDefaultErrorHandlerNotHandledPolicyTest.assertEquals((Object)true, (Object)out.getProperty("CamelFailureHandled"));
        SpringDefaultErrorHandlerNotHandledPolicyTest.assertEquals((Object)false, (Object)out.getProperty("CamelErrorHandlerHandled"));
        SpringDefaultErrorHandlerNotHandledPolicyTest.assertSame((String)"Should be same exception", (Object)e, (Object)out.getProperty("CamelExceptionCaught"));
    }
}

