/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.spring.processor;

import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.camel.spring.SpringTestSupport;
import org.springframework.context.support.AbstractXmlApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public class SpringManagedThreadsThreadPoolTest
extends SpringTestSupport {
    @Override
    protected AbstractXmlApplicationContext createApplicationContext() {
        return new ClassPathXmlApplicationContext("org/apache/camel/spring/processor/SpringManagedThreadsThreadPoolTest.xml");
    }

    public void testManagedThreadPool() throws Exception {
        MBeanServer mbeanServer = this.context.getManagementStrategy().getManagementAgent().getMBeanServer();
        ObjectName on = ObjectName.getInstance("org.apache.camel:context=localhost/camel-1,type=threadpools,name=\"myPool\"");
        Integer corePoolSize = (Integer)mbeanServer.getAttribute(on, "CorePoolSize");
        SpringManagedThreadsThreadPoolTest.assertEquals((int)2, (int)corePoolSize);
        Integer maxPoolSize = (Integer)mbeanServer.getAttribute(on, "MaximumPoolSize");
        SpringManagedThreadsThreadPoolTest.assertEquals((int)4, (int)maxPoolSize);
        this.getMockEndpoint("mock:result").expectedMessageCount(1);
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
        String id = (String)mbeanServer.getAttribute(on, "Id");
        SpringManagedThreadsThreadPoolTest.assertEquals((String)"myPool", (String)id);
        String source = (String)mbeanServer.getAttribute(on, "SourceId");
        SpringManagedThreadsThreadPoolTest.assertEquals(null, (String)source);
        String routeId = (String)mbeanServer.getAttribute(on, "RouteId");
        SpringManagedThreadsThreadPoolTest.assertEquals(null, (String)routeId);
    }
}

