/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.spring.processor;

import org.apache.camel.CamelContext;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.spring.processor.SpringTestHelper;

public class SpringMethodCallTest
extends ContextTestSupport {
    public void testMethodCallType() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedBodiesReceived(new Object[]{"Camel"});
        mock.expectedHeaderReceived("foo", (Object)"Hi Camel");
        this.template.sendBody("direct:start", (Object)"Camel");
        this.assertMockEndpointsSatisfied();
    }

    public void testMethodCallRef() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:ref");
        mock.expectedBodiesReceived(new Object[]{"Camel"});
        mock.expectedHeaderReceived("foo", (Object)"Hi Camel");
        this.template.sendBody("direct:ref", (Object)"Camel");
        this.assertMockEndpointsSatisfied();
    }

    public void testToBeanType() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedBodiesReceived(new Object[]{"Hi Camel", "Hi World"});
        this.template.sendBody("direct:tobeantype", (Object)"Camel");
        this.template.sendBody("direct:tobeantype", (Object)"World");
        this.assertMockEndpointsSatisfied();
    }

    protected CamelContext createCamelContext() throws Exception {
        return SpringTestHelper.createSpringCamelContext(this, "/org/apache/camel/spring/processor/SpringMethodCallTest.xml");
    }
}

