/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.spring.processor;

import org.apache.camel.Exchange;
import org.apache.camel.Route;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.impl.RoutePolicySupport;
import org.apache.camel.spring.SpringTestSupport;
import org.springframework.context.support.AbstractXmlApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public class SpringRoutePoliciesTest
extends SpringTestSupport {
    @Override
    protected AbstractXmlApplicationContext createApplicationContext() {
        return new ClassPathXmlApplicationContext("org/apache/camel/spring/processor/SpringRoutePoliciesTest.xml");
    }

    public void testCustomPolicies() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedBodiesReceived(new Object[]{"Hello World"});
        mock.expectedHeaderReceived("A", (Object)"A");
        mock.expectedHeaderReceived("B", (Object)"B");
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
    }

    public static final class MyCustomRoutePolicy
    extends RoutePolicySupport {
        private final String name;

        private MyCustomRoutePolicy(String name) {
            this.name = name;
        }

        public void onExchangeBegin(Route route, Exchange exchange) {
            exchange.getIn().setHeader(this.name, (Object)this.name);
        }
    }
}

