/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.spring.processor;

import org.apache.camel.CamelContext;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.spring.processor.SpringTestHelper;

public class SpringWireTapUsingFireAndForgetCopyTest
extends ContextTestSupport {
    protected CamelContext createCamelContext() throws Exception {
        return SpringTestHelper.createSpringCamelContext(this, "org/apache/camel/spring/processor/SpringWireTapUsingFireAndForgetCopyTest.xml");
    }

    public void testFireAndForgetUsingExpression() throws Exception {
        MockEndpoint result = this.getMockEndpoint("mock:result");
        result.expectedBodiesReceived(new Object[]{"World"});
        MockEndpoint foo = this.getMockEndpoint("mock:foo");
        foo.expectedBodiesReceived(new Object[]{"Bye World"});
        this.template.sendBody("direct:start", (Object)"World");
        this.assertMockEndpointsSatisfied();
        Exchange e1 = (Exchange)result.getReceivedExchanges().get(0);
        Exchange e2 = (Exchange)foo.getReceivedExchanges().get(0);
        SpringWireTapUsingFireAndForgetCopyTest.assertNotSame((String)"Should not be same Exchange", (Object)e1, (Object)e2);
        SpringWireTapUsingFireAndForgetCopyTest.assertEquals((String)"direct://start", (String)e1.getFromEndpoint().getEndpointUri());
        SpringWireTapUsingFireAndForgetCopyTest.assertEquals((String)"direct://start", (String)e2.getFromEndpoint().getEndpointUri());
    }

    public void testFireAndForgetUsingProcessor() throws Exception {
        MockEndpoint result = this.getMockEndpoint("mock:result");
        result.expectedBodiesReceived(new Object[]{"World"});
        MockEndpoint foo = this.getMockEndpoint("mock:foo");
        foo.expectedBodiesReceived(new Object[]{"Bye World"});
        foo.expectedHeaderReceived("foo", (Object)"bar");
        this.template.sendBody("direct:start2", (Object)"World");
        this.assertMockEndpointsSatisfied();
        Exchange e1 = (Exchange)result.getReceivedExchanges().get(0);
        Exchange e2 = (Exchange)foo.getReceivedExchanges().get(0);
        SpringWireTapUsingFireAndForgetCopyTest.assertNotSame((String)"Should not be same Exchange", (Object)e1, (Object)e2);
        SpringWireTapUsingFireAndForgetCopyTest.assertEquals((String)"direct://start2", (String)e1.getFromEndpoint().getEndpointUri());
        SpringWireTapUsingFireAndForgetCopyTest.assertEquals((String)"direct://start2", (String)e2.getFromEndpoint().getEndpointUri());
    }

    public static class MyProcessor
    implements Processor {
        public void process(Exchange exchange) throws Exception {
            String body = (String)exchange.getIn().getBody(String.class);
            exchange.getIn().setBody((Object)("Bye " + body));
            exchange.getIn().setHeader("foo", (Object)"bar");
        }
    }
}

