/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.spring.processor;

import org.apache.camel.CamelContext;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.spring.processor.SpringTestHelper;

public class SpringXPathHeaderTest
extends ContextTestSupport {
    public void testChoiceWithHeaderSelectCamel() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:camel");
        mock.expectedBodiesReceived(new Object[]{"<name>King</name>"});
        mock.expectedHeaderReceived("type", (Object)"Camel");
        this.template.sendBodyAndHeader("direct:in", (Object)"<name>King</name>", "type", (Object)"Camel");
        mock.assertIsSatisfied();
    }

    public void testChoiceWithNoHeaderSelectDonkey() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:donkey");
        mock.expectedBodiesReceived(new Object[]{"<name>Kong</name>"});
        this.template.sendBody("direct:in", (Object)"<name>Kong</name>");
        mock.assertIsSatisfied();
    }

    public void testChoiceWithNoHeaderSelectOther() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:other");
        mock.expectedBodiesReceived(new Object[]{"<name>Other</name>"});
        this.template.sendBody("direct:in", (Object)"<name>Other</name>");
        mock.assertIsSatisfied();
    }

    protected CamelContext createCamelContext() throws Exception {
        return SpringTestHelper.createSpringCamelContext(this, "org/apache/camel/spring/processor/SpringXPathHeaderTest-context.xml");
    }
}

