/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.spring.processor.idempotent;

import java.io.File;
import org.apache.camel.CamelContext;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.spi.IdempotentRepository;
import org.apache.camel.spring.processor.SpringTestHelper;
import org.apache.camel.util.FileUtil;

public class FileConsumerIdempotentTest
extends ContextTestSupport {
    private IdempotentRepository<String> repo;

    protected CamelContext createCamelContext() throws Exception {
        return SpringTestHelper.createSpringCamelContext(this, "org/apache/camel/spring/processor/idempotent/fileConsumerIdempotentTest.xml");
    }

    protected void setUp() throws Exception {
        FileConsumerIdempotentTest.deleteDirectory((String)"target/fileidempotent");
        super.setUp();
        this.repo = (IdempotentRepository)this.context.getRegistry().lookup("fileStore", IdempotentRepository.class);
    }

    public void testIdempotent() throws Exception {
        this.template.sendBodyAndHeader("file://target/fileidempotent/", (Object)"Hello World", "CamelFileName", (Object)"report.txt");
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(1);
        this.assertMockEndpointsSatisfied();
        mock.reset();
        mock.expectedMessageCount(0);
        File file = new File("target/fileidempotent/done/report.txt");
        File renamed = new File("target/fileidempotent/report.txt");
        file = file.getAbsoluteFile();
        file.renameTo(renamed.getAbsoluteFile());
        Thread.sleep(2000L);
        this.assertMockEndpointsSatisfied();
        String name = FileUtil.normalizePath((String)new File("target/fileidempotent/report.txt").getAbsolutePath());
        FileConsumerIdempotentTest.assertTrue((String)("Should contain file: " + name), (boolean)this.repo.contains((Object)name));
    }
}

