/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.spring.processor.onexception;

import org.apache.camel.CamelContext;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.spring.processor.SpringTestHelper;

public class DeadLetterChannelHandledExampleTest
extends ContextTestSupport {
    public void testOrderOK() throws Exception {
        MockEndpoint result = this.getMockEndpoint("mock:result");
        result.expectedBodiesReceived(new Object[]{"Order OK"});
        result.expectedHeaderReceived("orderid", (Object)"123");
        MockEndpoint error = this.getMockEndpoint("mock:error");
        error.expectedMessageCount(0);
        Object out = this.template.requestBodyAndHeader("direct:start", (Object)"Order: MacBook Pro", "customerid", (Object)"444");
        DeadLetterChannelHandledExampleTest.assertEquals((Object)"Order OK", (Object)out);
        this.assertMockEndpointsSatisfied();
    }

    public void testOrderERROR() throws Exception {
        MockEndpoint error = this.getMockEndpoint("mock:error");
        error.expectedBodiesReceived(new Object[]{"Order ERROR"});
        error.expectedHeaderReceived("orderid", (Object)"failed");
        MockEndpoint result = this.getMockEndpoint("mock:result");
        result.expectedMessageCount(0);
        Object out = this.template.requestBodyAndHeader("direct:start", (Object)"Order: kaboom", "customerid", (Object)"555");
        DeadLetterChannelHandledExampleTest.assertEquals((Object)"Order ERROR", (Object)out);
        this.assertMockEndpointsSatisfied();
    }

    protected CamelContext createCamelContext() throws Exception {
        return SpringTestHelper.createSpringCamelContext(this, "/org/apache/camel/spring/processor/onexception/deadLetterChannelHandledExampleTest.xml");
    }
}

