/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.spring.processor.onexception;

import org.apache.camel.CamelContext;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.spring.processor.SpringTestHelper;

public class SpringOnExceptionSubRouteTest
extends ContextTestSupport {
    public void testOrderOk() throws Exception {
        MockEndpoint result = this.getMockEndpoint("mock:result");
        result.expectedBodiesReceived(new Object[]{"Order OK"});
        result.expectedHeaderReceived("orderid", (Object)"123");
        MockEndpoint error = this.getMockEndpoint("mock:error");
        error.expectedMessageCount(0);
        Object out = this.template.requestBodyAndHeader("direct:start", (Object)"Order: MacBook Pro", "customerid", (Object)"444");
        SpringOnExceptionSubRouteTest.assertEquals((Object)"Order OK", (Object)out);
        this.assertMockEndpointsSatisfied();
    }

    public void testOrderError() throws Exception {
        MockEndpoint error = this.getMockEndpoint("mock:error");
        error.expectedBodiesReceived(new Object[]{"Order ERROR"});
        error.expectedHeaderReceived("orderid", (Object)"failed");
        MockEndpoint result = this.getMockEndpoint("mock:result");
        result.expectedMessageCount(0);
        Object out = this.template.requestBodyAndHeader("direct:start", (Object)"Order: kaboom", "customerid", (Object)"555");
        SpringOnExceptionSubRouteTest.assertEquals((Object)"Order ERROR", (Object)out);
        this.assertMockEndpointsSatisfied();
    }

    public void testOrderErrorWithNoExceptionClause() throws Exception {
        MockEndpoint error = this.getMockEndpoint("mock:error");
        error.expectedMessageCount(0);
        MockEndpoint result = this.getMockEndpoint("mock:result");
        result.expectedMessageCount(0);
        try {
            this.template.requestBodyAndHeader("direct:start_with_no_handler", (Object)"Order: kaboom", "customerid", (Object)"555");
            SpringOnExceptionSubRouteTest.fail((String)"Should throw an Exception");
        }
        catch (Exception e) {
            SpringOnExceptionSubRouteTest.assertEquals((String)"Cannot order: kaboom", (String)e.getCause().getMessage());
        }
        this.assertMockEndpointsSatisfied();
    }

    protected CamelContext createCamelContext() throws Exception {
        return SpringTestHelper.createSpringCamelContext(this, "/org/apache/camel/spring/processor/onexception/onExceptionSubRouteTest.xml");
    }
}

