/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.spring.processor.tracing;

import org.apache.camel.Exchange;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.processor.interceptor.TraceInterceptorCustomJpaMessage;
import org.apache.camel.spring.processor.tracing.TracingTestBase;
import org.springframework.context.support.AbstractXmlApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public class TraceInterceptorCustomJpaMessageTest
extends TracingTestBase {
    @Override
    protected AbstractXmlApplicationContext createApplicationContext() {
        return new ClassPathXmlApplicationContext("org/apache/camel/spring/processor/tracing/traceInterceptorCustomJpaMessageContext.xml");
    }

    @Override
    protected void prepareTestTracerExceptionInOut() {
        MockEndpoint traces = this.getMockEndpoint("mock:jpa-trace");
        traces.expectedMessageCount(14);
    }

    @Override
    protected void validateTestTracerExceptionInOut() {
        MockEndpoint traces = this.getMockEndpoint("mock:jpa-trace");
        TraceInterceptorCustomJpaMessageTest.assertEquals((int)14, (int)traces.getExchanges().size());
        for (Exchange exchange : traces.getExchanges()) {
            TraceInterceptorCustomJpaMessageTest.assertEquals(exchange.getIn().getBody().getClass(), TraceInterceptorCustomJpaMessage.class);
        }
    }

    @Override
    protected int getMessageCount() {
        MockEndpoint traces = this.getMockEndpoint("mock:jpa-trace");
        return traces.getExchanges().size();
    }
}

