/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.spring.processor.tracing;

import java.util.List;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.processor.interceptor.TraceHandlerTestHandler;
import org.apache.camel.processor.interceptor.Tracer;
import org.apache.camel.spring.SpringTestSupport;

public abstract class TracingTestBase
extends SpringTestSupport {
    protected List<StringBuilder> getTracedMessages() {
        Tracer tracer = (Tracer)this.applicationContext.getBean("tracer");
        TraceHandlerTestHandler handler = (TraceHandlerTestHandler)tracer.getTraceHandler();
        return handler.getEventMessages();
    }

    protected void prepareTestTracerExceptionInOut() {
    }

    protected void validateTestTracerExceptionInOut() {
        List<StringBuilder> tracedMessages = this.getTracedMessages();
        TracingTestBase.assertEquals((int)7, (int)tracedMessages.size());
        for (StringBuilder tracedMessage : tracedMessages) {
            String message = tracedMessage.toString();
            TracingTestBase.assertTrue((boolean)message.startsWith("In"));
            TracingTestBase.assertTrue((boolean)message.contains("Out:"));
        }
        TracingTestBase.assertTrue((boolean)tracedMessages.get(4).toString().contains("Ex:"));
    }

    protected int getMessageCount() {
        return this.getTracedMessages().size();
    }

    public void testTracerExceptionInOut() throws Exception {
        MockEndpoint result = this.getMockEndpoint("mock:result");
        ((Tracer)this.context.getDefaultTracer()).setTraceOutExchanges(true);
        result.expectedMessageCount(3);
        this.prepareTestTracerExceptionInOut();
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.template.sendBody("direct:start", (Object)"Bye World");
        try {
            this.template.sendBody("direct:start", (Object)"Kaboom");
            TracingTestBase.fail((String)"Should have thrown exception");
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.template.sendBody("direct:start", (Object)"Hello Camel");
        this.assertMockEndpointsSatisfied();
        this.validateTestTracerExceptionInOut();
    }
}

