/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.spring.remoting;

import org.apache.camel.RuntimeCamelException;
import org.apache.camel.spring.SpringTestSupport;
import org.apache.camel.spring.remoting.EchoPojoDirect;
import org.apache.camel.spring.remoting.MyEchoRuntimeException;
import org.springframework.context.support.AbstractXmlApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public class EchoSpringRemotingPojoDirectTest
extends SpringTestSupport {
    @Override
    protected int getExpectedRouteCount() {
        return 0;
    }

    @Override
    protected AbstractXmlApplicationContext createApplicationContext() {
        return new ClassPathXmlApplicationContext("org/apache/camel/spring/remoting/echo-pojo-direct.xml");
    }

    public void testPojoOk() throws Exception {
        String out = (String)this.template.requestBody("direct:start", (Object)"Claus", String.class);
        EchoSpringRemotingPojoDirectTest.assertEquals((String)"Claus Claus", (String)out);
    }

    public void testPojoKabom() throws Exception {
        try {
            this.template.requestBody("direct:start", (Object)"Kabom", String.class);
            EchoSpringRemotingPojoDirectTest.fail((String)"Should have thrown exception");
        }
        catch (RuntimeCamelException e) {
            EchoSpringRemotingPojoDirectTest.assertIsInstanceOf(MyEchoRuntimeException.class, (Object)e.getCause());
            EchoSpringRemotingPojoDirectTest.assertEquals((String)"Damn something went wrong", (String)e.getCause().getMessage());
        }
    }

    public void testPojoBeanKabom() throws Exception {
        try {
            EchoPojoDirect echoPojoDirect = (EchoPojoDirect)this.applicationContext.getBean("myPojoDirect");
            String out = echoPojoDirect.onEcho("Kabom");
            EchoSpringRemotingPojoDirectTest.assertNotNull((Object)out);
            EchoSpringRemotingPojoDirectTest.fail((String)"Should have thrown exception");
        }
        catch (RuntimeException e) {
            EchoSpringRemotingPojoDirectTest.assertIsInstanceOf(MyEchoRuntimeException.class, (Object)e);
            EchoSpringRemotingPojoDirectTest.assertEquals((String)"Damn something went wrong", (String)e.getMessage());
        }
    }
}

