/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.spring.remoting;

import org.apache.camel.RuntimeCamelException;
import org.apache.camel.spring.SpringTestSupport;
import org.apache.camel.spring.remoting.MyEchoRuntimeException;
import org.springframework.context.support.AbstractXmlApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public class EchoSpringRemotingThrowingRuntimeExceptionTest
extends SpringTestSupport {
    @Override
    protected AbstractXmlApplicationContext createApplicationContext() {
        return new ClassPathXmlApplicationContext("org/apache/camel/spring/remoting/echo.xml");
    }

    public void testEchoOk() throws Exception {
        String out = (String)this.template.requestBody("direct:echo", (Object)"Claus", String.class);
        EchoSpringRemotingThrowingRuntimeExceptionTest.assertEquals((String)"Claus Claus", (String)out);
    }

    public void testEchoKabom() throws Exception {
        try {
            this.template.requestBody("direct:echo", (Object)"Kabom", String.class);
            EchoSpringRemotingThrowingRuntimeExceptionTest.fail((String)"Should have thrown exception");
        }
        catch (RuntimeCamelException e) {
            EchoSpringRemotingThrowingRuntimeExceptionTest.assertIsInstanceOf(MyEchoRuntimeException.class, (Object)e.getCause());
            EchoSpringRemotingThrowingRuntimeExceptionTest.assertEquals((String)"Damn something went wrong", (String)e.getCause().getMessage());
        }
    }

    public void testRouteOk() throws Exception {
        String out = (String)this.template.requestBody("direct:start", (Object)"Claus", String.class);
        EchoSpringRemotingThrowingRuntimeExceptionTest.assertEquals((String)"Claus Claus", (String)out);
    }

    public void testRouteKabom() throws Exception {
        try {
            this.template.requestBody("direct:start", (Object)"Kabom", String.class);
            EchoSpringRemotingThrowingRuntimeExceptionTest.fail((String)"Should have thrown exception");
        }
        catch (RuntimeCamelException e) {
            EchoSpringRemotingThrowingRuntimeExceptionTest.assertIsInstanceOf(MyEchoRuntimeException.class, (Object)e.getCause());
            EchoSpringRemotingThrowingRuntimeExceptionTest.assertEquals((String)"Damn something went wrong", (String)e.getCause().getMessage());
        }
    }
}

