/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.spring.remoting;

import java.util.List;
import org.apache.camel.EndpointInject;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePattern;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.spring.remoting.IAsyncService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit38.AbstractJUnit38SpringContextTests;

@ContextConfiguration
public class SpringRemotingWithOneWayTest
extends AbstractJUnit38SpringContextTests {
    private static final Logger LOG = LoggerFactory.getLogger(SpringRemotingWithOneWayTest.class);
    @Autowired
    protected IAsyncService myService;
    @EndpointInject(uri="mock:results")
    protected MockEndpoint endpoint;

    public void testAsyncInvocation() throws Exception {
        this.endpoint.expectedMessageCount(1);
        this.myService.doSomethingAsync("Hello");
        this.endpoint.assertIsSatisfied();
        List list = this.endpoint.getReceivedExchanges();
        for (Exchange exchange : list) {
            LOG.info("Received: " + exchange.getIn().getBody());
            ExchangePattern pattern = exchange.getPattern();
            SpringRemotingWithOneWayTest.assertEquals((String)("Expected pattern on exchange: " + exchange), (Object)ExchangePattern.InOnly, (Object)pattern);
        }
    }
}

