/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.spring.scan;

import java.lang.annotation.Annotation;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.HashSet;
import java.util.Set;
import org.apache.camel.impl.DefaultPackageScanClassResolver;
import org.apache.camel.spi.PackageScanFilter;
import org.apache.camel.spring.scan.ScanTestSupport;
import org.apache.camel.spring.scan.ScannableOne;
import org.apache.camel.spring.scan.ScannableTwo;
import org.apache.camel.spring.scan.a.ScanTargetOne;
import org.apache.camel.spring.scan.b.ScanTargetTwo;
import org.apache.camel.spring.scan.c.ScanTargetThree;

public class DefaultPackageScanClassResolverTest
extends ScanTestSupport {
    private DefaultPackageScanClassResolver resolver;
    private Set<Class<? extends Annotation>> annotations = new HashSet<Class<? extends Annotation>>();
    private String scanPackage = "org.apache.camel.spring.scan";

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.resolver = new DefaultPackageScanClassResolver();
        this.annotations.add(ScannableOne.class);
        this.annotations.add(ScannableTwo.class);
    }

    public void testAccepableSchema() {
        DefaultPackageScanClassResolverTest.assertFalse((String)"We should not accept the test by default!", (boolean)this.resolver.isAcceptableScheme("test://test"));
        this.resolver.setAcceptableSchemes("test:;test2:");
        DefaultPackageScanClassResolverTest.assertTrue((String)"We should accept the test:!", (boolean)this.resolver.isAcceptableScheme("test://test"));
        DefaultPackageScanClassResolverTest.assertTrue((String)"We should accept the test2:!", (boolean)this.resolver.isAcceptableScheme("test2://test"));
    }

    public void testFindByAnnotationWithoutExtraFilters() {
        Set scanned = this.resolver.findAnnotated(ScannableOne.class, new String[]{this.scanPackage});
        this.validateMatchingSetContains(scanned, ScanTargetOne.class, ScanTargetTwo.class);
        scanned = this.resolver.findAnnotated(ScannableTwo.class, new String[]{this.scanPackage});
        this.validateMatchingSetContains(scanned, ScanTargetThree.class);
    }

    public void testFindByAnnotationsWithoutExtraFilters() {
        Set scanned = this.resolver.findAnnotated(this.annotations, new String[]{this.scanPackage});
        this.validateMatchingSetContains(scanned, ScanTargetOne.class, ScanTargetTwo.class, ScanTargetThree.class);
    }

    public void testFindImplementationsWithoutExtraFilters() {
        Set scanned = this.resolver.findImplementations(ScanTargetOne.class, new String[]{this.scanPackage});
        this.validateMatchingSetContains(scanned, ScanTargetOne.class, ScanTargetTwo.class);
    }

    public void testFindByAnnotationWithIncludePackageFilter() {
        this.filter.addIncludePattern(this.scanPackage + ".b.*");
        this.resolver.addFilter((PackageScanFilter)this.filter);
        Set scanned = this.resolver.findAnnotated(ScannableOne.class, new String[]{this.scanPackage});
        this.validateMatchingSetContains(scanned, ScanTargetTwo.class);
        scanned = this.resolver.findAnnotated(ScannableTwo.class, new String[]{this.scanPackage});
        this.validateMatchingSetContains(scanned, new Class[0]);
    }

    public void testFindByAnnotationsWithIncludePackageFilter() {
        this.filter.addIncludePattern(this.scanPackage + ".b.*");
        this.filter.addIncludePattern(this.scanPackage + ".c.*");
        this.resolver.addFilter((PackageScanFilter)this.filter);
        Set scanned = this.resolver.findAnnotated(this.annotations, new String[]{"org.apache.camel.spring.scan"});
        this.validateMatchingSetContains(scanned, ScanTargetTwo.class, ScanTargetThree.class);
    }

    public void testFindByAnnotationWithExcludePackageFilter() {
        this.filter.addExcludePattern(this.scanPackage + ".b.*");
        this.filter.addExcludePattern(this.scanPackage + ".c.*");
        this.resolver.addFilter((PackageScanFilter)this.filter);
        Set scanned = this.resolver.findAnnotated(ScannableOne.class, new String[]{this.scanPackage});
        this.validateMatchingSetContains(scanned, ScanTargetOne.class);
        scanned = this.resolver.findAnnotated(ScannableTwo.class, new String[]{this.scanPackage});
        this.validateMatchingSetContains(scanned, new Class[0]);
    }

    public void testFindByAnnotationsWithExcludePackageFilter() {
        this.filter.addExcludePattern(this.scanPackage + ".a.*");
        Set scanned = this.resolver.findAnnotated(this.annotations, new String[]{"org.apache.camel.spring.scan"});
        this.validateMatchingSetContains(scanned, ScanTargetTwo.class, ScanTargetThree.class);
    }

    public void testFindByFilterWithIncludePackageFilter() {
        this.filter.addIncludePattern(this.scanPackage + ".**.ScanTarget*");
        this.resolver.addFilter((PackageScanFilter)this.filter);
        Set scanned = this.resolver.findByFilter((PackageScanFilter)this.filter, new String[]{"org.apache.camel.spring.scan"});
        this.validateMatchingSetContains(scanned, ScanTargetOne.class, ScanTargetTwo.class, ScanTargetThree.class);
    }

    public void testFindImplementationsWithIncludePackageFilter() {
        this.filter.addIncludePattern(this.scanPackage + ".b.*");
        this.resolver.addFilter((PackageScanFilter)this.filter);
        Set scanned = this.resolver.findImplementations(ScanTargetOne.class, new String[]{this.scanPackage});
        this.validateMatchingSetContains(scanned, ScanTargetTwo.class);
    }

    public void testFindImplementationsWithExcludePackageFilter() {
        this.filter.addExcludePattern(this.scanPackage + ".a.*");
        this.resolver.addFilter((PackageScanFilter)this.filter);
        Set scanned = this.resolver.findImplementations(ScanTargetOne.class, new String[]{this.scanPackage});
        this.validateMatchingSetContains(scanned, ScanTargetTwo.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testFindByFilterPackageInJarUrl() throws Exception {
        ClassLoader savedClassLoader = null;
        try {
            savedClassLoader = Thread.currentThread().getContextClassLoader();
            URL url = ((Object)((Object)this)).getClass().getResource("/package_scan_test.jar");
            URL[] urls = new URL[]{new URL("jar:" + url.toString() + "!/")};
            URLClassLoader classLoader = new URLClassLoader(urls, savedClassLoader);
            Thread.currentThread().setContextClassLoader(classLoader);
            this.resolver = new DefaultPackageScanClassResolver();
            this.filter.addIncludePattern("a.*.c.*");
            this.resolver.addFilter((PackageScanFilter)this.filter);
            Set scanned = this.resolver.findByFilter((PackageScanFilter)this.filter, new String[]{"a.b.c"});
            DefaultPackageScanClassResolverTest.assertEquals((int)1, (int)scanned.size());
            DefaultPackageScanClassResolverTest.assertEquals((String)"class a.b.c.Test", (String)((Class)scanned.iterator().next()).toString());
        }
        finally {
            if (savedClassLoader != null) {
                Thread.currentThread().setContextClassLoader(savedClassLoader);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testFindByFilterPackageInJarUrlWithPlusChars() throws Exception {
        ClassLoader savedClassLoader = null;
        try {
            savedClassLoader = Thread.currentThread().getContextClassLoader();
            URL url = ((Object)((Object)this)).getClass().getResource("/package+scan+test.jar");
            URL[] urls = new URL[]{new URL("jar:" + url.toString() + "!/")};
            URLClassLoader classLoader = new URLClassLoader(urls, savedClassLoader);
            Thread.currentThread().setContextClassLoader(classLoader);
            this.resolver = new DefaultPackageScanClassResolver();
            this.filter.addIncludePattern("a.*.c.*");
            this.resolver.addFilter((PackageScanFilter)this.filter);
            Set scanned = this.resolver.findByFilter((PackageScanFilter)this.filter, new String[]{"a.b.c"});
            DefaultPackageScanClassResolverTest.assertEquals((int)1, (int)scanned.size());
            DefaultPackageScanClassResolverTest.assertEquals((String)"class a.b.c.Test", (String)((Class)scanned.iterator().next()).toString());
        }
        finally {
            if (savedClassLoader != null) {
                Thread.currentThread().setContextClassLoader(savedClassLoader);
            }
        }
    }
}

