/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.spring.scan;

import java.util.LinkedHashSet;
import java.util.Set;
import junit.framework.TestCase;
import org.apache.camel.impl.scan.AnnotatedWithAnyPackageScanFilter;
import org.apache.camel.impl.scan.AnnotatedWithPackageScanFilter;
import org.apache.camel.impl.scan.AssignableToPackageScanFilter;
import org.apache.camel.impl.scan.CompositePackageScanFilter;
import org.apache.camel.impl.scan.InvertingPackageScanFilter;
import org.apache.camel.spi.PackageScanFilter;
import org.apache.camel.spring.scan.ScannableOne;
import org.apache.camel.spring.scan.ScannableTwo;
import org.apache.camel.spring.scan.a.ScanTargetOne;
import org.apache.camel.spring.scan.b.ScanTargetTwo;
import org.apache.camel.spring.scan.c.ScanTargetThree;
import org.apache.camel.util.CollectionHelper;

public class PackageScanFiltersTest
extends TestCase {
    public void testAssignableToPackageScanFilter() {
        AssignableToPackageScanFilter filter = new AssignableToPackageScanFilter();
        PackageScanFiltersTest.assertFalse((boolean)filter.matches(ScanTargetOne.class));
        filter = new AssignableToPackageScanFilter(ScanTargetOne.class);
        this.validateFilter((PackageScanFilter)filter, ScanTargetOne.class);
        filter = new AssignableToPackageScanFilter(ScanTargetOne.class);
        this.validateFilter((PackageScanFilter)filter, ScanTargetTwo.class);
        LinkedHashSet<Class> classes = new LinkedHashSet<Class>();
        classes.add(ScanTargetOne.class);
        classes.add(ScanTargetThree.class);
        filter = new AssignableToPackageScanFilter(classes);
        this.validateFilter((PackageScanFilter)filter, ScanTargetOne.class);
        this.validateFilter((PackageScanFilter)filter, ScanTargetTwo.class);
        this.validateFilter((PackageScanFilter)filter, ScanTargetThree.class);
        PackageScanFiltersTest.assertTrue((boolean)filter.toString().contains("ScanTargetOne"));
        PackageScanFiltersTest.assertTrue((boolean)filter.toString().contains("ScanTargetThree"));
    }

    public void testAnnotatedWithAnyPackageScanFilter() {
        LinkedHashSet<Class> annotations = new LinkedHashSet<Class>();
        annotations.add(ScannableOne.class);
        annotations.add(ScannableTwo.class);
        AnnotatedWithAnyPackageScanFilter filter = new AnnotatedWithAnyPackageScanFilter(annotations);
        Class<ScanTargetOne> type = ScanTargetOne.class;
        this.validateFilter((PackageScanFilter)filter, type);
        this.validateFilter((PackageScanFilter)filter, ScanTargetThree.class);
        PackageScanFiltersTest.assertEquals((String)"annotated with any @[[interface org.apache.camel.spring.scan.ScannableOne, interface org.apache.camel.spring.scan.ScannableTwo]]", (String)filter.toString());
    }

    public void testAnnotatedWithPackageScanFilter() {
        AnnotatedWithPackageScanFilter filter = new AnnotatedWithPackageScanFilter(ScannableOne.class);
        this.validateFilter((PackageScanFilter)filter, ScanTargetOne.class);
        this.validateFilter((PackageScanFilter)filter, ScanTargetTwo.class);
        filter = new AnnotatedWithPackageScanFilter(ScannableTwo.class);
        this.validateFilter((PackageScanFilter)filter, ScanTargetThree.class);
        PackageScanFiltersTest.assertEquals((String)"annotated with @ScannableTwo", (String)filter.toString());
    }

    public void testCompositePackageScanFilter() {
        AnnotatedWithPackageScanFilter one = new AnnotatedWithPackageScanFilter(ScannableOne.class);
        AssignableToPackageScanFilter two = new AssignableToPackageScanFilter(ScanTargetOne.class);
        Set filters = CollectionHelper.createSetContaining((Object[])new PackageScanFilter[]{one, two});
        CompositePackageScanFilter filter = new CompositePackageScanFilter(filters);
        this.validateFilter((PackageScanFilter)filter, ScanTargetOne.class);
        this.validateFilter((PackageScanFilter)filter, ScanTargetTwo.class);
        filter = new CompositePackageScanFilter();
        filter.addFilter((PackageScanFilter)one);
        filter.addFilter((PackageScanFilter)two);
        this.validateFilter((PackageScanFilter)filter, ScanTargetOne.class);
        this.validateFilter((PackageScanFilter)filter, ScanTargetTwo.class);
    }

    public void testInvertingFilter() {
        InvertingPackageScanFilter filter = new InvertingPackageScanFilter((PackageScanFilter)new AnnotatedWithPackageScanFilter(ScannableOne.class));
        this.validateFilter((PackageScanFilter)filter, ScanTargetThree.class);
        PackageScanFiltersTest.assertEquals((String)"![annotated with @ScannableOne]", (String)filter.toString());
    }

    private void validateFilter(PackageScanFilter filter, Class<?> type) {
        PackageScanFiltersTest.assertTrue((boolean)filter.matches(type));
        PackageScanFiltersTest.assertFalse((boolean)new InvertingPackageScanFilter(filter).matches(type));
    }
}

