/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.spring.scan;

import java.io.File;
import java.io.FileInputStream;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.jar.JarFile;
import org.apache.camel.core.xml.scan.PatternBasedPackageScanFilter;
import org.apache.camel.spring.scan.ScanTestSupport;
import org.apache.camel.util.CollectionHelper;

public class PatternBasedPackageScanFilterTest
extends ScanTestSupport {
    private Set<Class<?>> allClasses;

    @Override
    public void setUp() throws Exception {
        this.allClasses = new HashSet();
        this.allClasses.add(List.class);
        this.allClasses.add(ArrayList.class);
        this.allClasses.add(LinkedList.class);
        this.allClasses.add(File.class);
        this.allClasses.add(FileInputStream.class);
        this.allClasses.add(RandomAccessFile.class);
        this.allClasses.add(JarFile.class);
        super.setUp();
    }

    public void testNoPattersIncludeAllClasses() {
        this.validateMatchingSetContains(this.allClasses);
    }

    public void testIncludePatterns() {
        this.addIncludePatterns("*");
        this.validateMatchingSetContains(this.allClasses);
        this.filter = new PatternBasedPackageScanFilter();
        this.addIncludePatterns("java*");
        this.validateMatchingSetContains(this.allClasses);
        this.filter = new PatternBasedPackageScanFilter();
        this.addIncludePatterns("java.io.*");
        this.validateMatchingSetContains(File.class, FileInputStream.class, RandomAccessFile.class);
        this.filter = new PatternBasedPackageScanFilter();
        this.addIncludePatterns("java.util.**");
        this.validateMatchingSetContains(List.class, ArrayList.class, LinkedList.class, JarFile.class);
        this.filter = new PatternBasedPackageScanFilter();
        this.addIncludePatterns("java.io.*", "java.util.*");
        this.validateMatchingSetContains(this.allClasses);
        this.filter = new PatternBasedPackageScanFilter();
        this.addIncludePatterns("java.io.File");
        this.validateMatchingSetContains(File.class);
        this.filter = new PatternBasedPackageScanFilter();
        this.addIncludePatterns("java.io.File*");
        this.validateMatchingSetContains(File.class, FileInputStream.class);
        this.filter = new PatternBasedPackageScanFilter();
        this.addIncludePatterns("java.io.*File*");
        this.validateMatchingSetContains(File.class, FileInputStream.class, RandomAccessFile.class);
        this.filter = new PatternBasedPackageScanFilter();
        this.addIncludePatterns("java.**.*File*");
        this.validateMatchingSetContains(File.class, FileInputStream.class, RandomAccessFile.class, JarFile.class);
        this.filter = new PatternBasedPackageScanFilter();
        this.addIncludePatterns("java.util.*List");
        this.validateMatchingSetContains(List.class, ArrayList.class, LinkedList.class);
        this.filter = new PatternBasedPackageScanFilter();
        this.addIncludePatterns("java.lang", "java.lang.*");
        this.validateMatchingSetContains(new Class[0]);
        this.filter = new PatternBasedPackageScanFilter();
        this.addIncludePatterns("java.lang", "java.lang.*");
        this.validateMatchingSetContains(new Class[0]);
    }

    public void testExcludePatterns() {
        this.addExcludePatterns("*");
        this.validateMatchingSetContains(new Class[0]);
        this.filter = new PatternBasedPackageScanFilter();
        this.addExcludePatterns("java*");
        this.validateMatchingSetContains(new Class[0]);
        this.filter = new PatternBasedPackageScanFilter();
        this.addExcludePatterns("java.io.*");
        this.validateMatchingSetContains(List.class, ArrayList.class, LinkedList.class, JarFile.class);
        this.filter = new PatternBasedPackageScanFilter();
        this.addExcludePatterns("java.util.**");
        this.validateMatchingSetContains(File.class, FileInputStream.class, RandomAccessFile.class);
        this.filter = new PatternBasedPackageScanFilter();
        this.addExcludePatterns("java.io.*", "java.util.*");
        this.validateMatchingSetContains(new Class[0]);
        this.filter = new PatternBasedPackageScanFilter();
        this.addExcludePatterns("java.io.File");
        this.validateMatchingSetContains(List.class, ArrayList.class, LinkedList.class, JarFile.class, FileInputStream.class, RandomAccessFile.class);
        this.filter = new PatternBasedPackageScanFilter();
        this.addExcludePatterns("java.io.File*");
        this.validateMatchingSetContains(List.class, ArrayList.class, LinkedList.class, JarFile.class, RandomAccessFile.class);
        this.filter = new PatternBasedPackageScanFilter();
        this.addExcludePatterns("java.io.*File*");
        this.validateMatchingSetContains(List.class, ArrayList.class, LinkedList.class, JarFile.class);
        this.filter = new PatternBasedPackageScanFilter();
        this.addExcludePatterns("java.**.*File*");
        this.validateMatchingSetContains(List.class, ArrayList.class, LinkedList.class);
        this.filter = new PatternBasedPackageScanFilter();
        this.addExcludePatterns("java.util.*List");
        this.validateMatchingSetContains(File.class, FileInputStream.class, RandomAccessFile.class, JarFile.class);
        this.filter = new PatternBasedPackageScanFilter();
        this.addExcludePatterns("java.lang", "java.lang.*");
        this.validateMatchingSetContains(this.allClasses);
        this.filter = new PatternBasedPackageScanFilter();
        this.addExcludePatterns("java.lang", "java.lang.*");
        this.validateMatchingSetContains(this.allClasses);
    }

    public void testExcludeHasPrecedenceOverInclude() {
        this.addIncludePatterns("java.util.*");
        this.addExcludePatterns("java.util.jar.*");
        this.validateMatchingSetContains(List.class, ArrayList.class, LinkedList.class);
    }

    public void testBulkIncludeAdd() {
        Set includes = CollectionHelper.createSetContaining((Object[])new String[]{"java.io.*", "java.util.*"});
        this.filter.addIncludePatterns((Collection)includes);
        this.validateMatchingSetContains(this.allClasses);
    }

    public void testBulkExcludeAdd() {
        Set excludes = CollectionHelper.createSetContaining((Object[])new String[]{"java.io.*", "java.util.*"});
        this.filter.addExcludePatterns((Collection)excludes);
        this.validateMatchingSetContains(new Class[0]);
    }

    protected void validateMatchingSetContains(Class<?> ... matchingClasses) {
        super.validateMatchingSetContains(this.allClasses, matchingClasses);
    }

    protected void validateMatchingSetContains(Set<Class<?>> matchingClasses) {
        super.validateMatchingSetContains(this.allClasses, matchingClasses);
    }
}

