/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.spring.scan;

import java.util.HashSet;
import java.util.Set;
import junit.framework.TestCase;
import org.apache.camel.core.xml.scan.PatternBasedPackageScanFilter;

public abstract class ScanTestSupport
extends TestCase {
    protected PatternBasedPackageScanFilter filter;

    public void setUp() throws Exception {
        this.filter = new PatternBasedPackageScanFilter();
    }

    protected void validateMatchingSetContains(Set<Class<?>> scannedClasses, Class<?> ... matchingClasses) {
        HashSet expectedSet = new HashSet();
        for (Class<?> expected : matchingClasses) {
            expectedSet.add(expected);
        }
        this.validateMatchingSetContains(scannedClasses, expectedSet);
    }

    protected void validateMatchingSetContains(Set<Class<?>> scannedClasses, Set<Class<?>> matchingClasses) {
        Set<Class<?>> matching = this.getMatchingClasses(scannedClasses, this.filter);
        ScanTestSupport.assertEquals((String)"Incorrect number of classes matched", (int)matchingClasses.size(), (int)matching.size());
        for (Class<?> expected : matchingClasses) {
            ScanTestSupport.assertTrue((String)("Expected matching class '" + expected + "' is not present"), (boolean)matching.contains(expected));
        }
    }

    protected void addIncludePatterns(String ... patterns) {
        for (String pattern : patterns) {
            this.filter.addIncludePattern(pattern);
        }
    }

    protected void addExcludePatterns(String ... patterns) {
        for (String pattern : patterns) {
            this.filter.addExcludePattern(pattern);
        }
    }

    public Set<Class<?>> getMatchingClasses(Set<Class<?>> scannedClasses, PatternBasedPackageScanFilter filter) {
        HashSet matching = new HashSet();
        for (Class<?> candidate : scannedClasses) {
            if (!filter.matches(candidate)) continue;
            matching.add(candidate);
        }
        return matching;
    }
}

