/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.spring.xml;

import java.util.List;
import org.apache.camel.Processor;
import org.apache.camel.Route;
import org.apache.camel.builder.RouteBuilderTest;
import org.apache.camel.spring.SpringCamelContext;
import org.springframework.context.support.AbstractXmlApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public class SpringXmlRouteBuilderTest
extends RouteBuilderTest {
    protected AbstractXmlApplicationContext applicationContext;

    protected List<Route> buildSimpleRoute() {
        return this.getRoutesFromContext("org/apache/camel/spring/xml/buildSimpleRoute.xml");
    }

    protected List<Route> buildCustomProcessor() {
        List<Route> answer = this.getRoutesFromContext("org/apache/camel/spring/xml/buildCustomProcessor.xml");
        this.myProcessor = (Processor)this.applicationContext.getBean("myProcessor");
        return answer;
    }

    protected List<Route> buildCustomProcessorWithFilter() {
        List<Route> answer = this.getRoutesFromContext("org/apache/camel/spring/xml/buildCustomProcessorWithFilter.xml");
        this.myProcessor = (Processor)this.applicationContext.getBean("myProcessor");
        return answer;
    }

    protected List<Route> buildSimpleRouteWithHeaderPredicate() {
        return this.getRoutesFromContext("org/apache/camel/spring/xml/buildSimpleRouteWithHeaderPredicate.xml");
    }

    protected List<Route> buildSimpleRouteWithChoice() {
        return this.getRoutesFromContext("org/apache/camel/spring/xml/buildSimpleRouteWithChoice.xml");
    }

    protected List<Route> buildWireTap() {
        return this.getRoutesFromContext("org/apache/camel/spring/xml/buildWireTap.xml");
    }

    protected List<Route> buildDynamicRecipientList() {
        return this.getRoutesFromContext("org/apache/camel/spring/xml/buildDynamicRecipientList.xml");
    }

    protected List<Route> buildStaticRecipientList() {
        return this.getRoutesFromContext("org/apache/camel/spring/xml/buildStaticRecipientList.xml");
    }

    protected List<Route> buildSplitter() {
        return this.getRoutesFromContext("org/apache/camel/spring/xml/buildSplitter.xml");
    }

    protected List<Route> buildIdempotentConsumer() {
        return this.getRoutesFromContext("org/apache/camel/spring/xml/buildIdempotentConsumer.xml");
    }

    public void testIdempotentConsumer() throws Exception {
    }

    public void testRouteWithInterceptor() throws Exception {
    }

    protected List<Route> getRoutesFromContext(String classpathConfigFile) {
        this.applicationContext = new ClassPathXmlApplicationContext(classpathConfigFile);
        SpringCamelContext context = (SpringCamelContext)this.applicationContext.getBeansOfType(SpringCamelContext.class).values().iterator().next();
        SpringXmlRouteBuilderTest.assertNotNull((String)("No Camel Context in file: " + classpathConfigFile), (Object)context);
        List routes = context.getRoutes();
        SpringXmlRouteBuilderTest.assertNotNull((String)("No routes available for context: " + context.getName() + " in file: " + classpathConfigFile), (Object)routes);
        return routes;
    }
}

