/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.spring;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.spi.PackageScanFilter;
import org.apache.camel.spring.SpringCamelContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;

public class ContextScanRouteBuilderFinder {
    private static final transient Logger LOG = LoggerFactory.getLogger(ContextScanRouteBuilderFinder.class);
    private final ApplicationContext applicationContext;
    private final PackageScanFilter filter;

    public ContextScanRouteBuilderFinder(SpringCamelContext camelContext, PackageScanFilter filter) {
        this.applicationContext = camelContext.getApplicationContext();
        this.filter = filter;
    }

    public void appendBuilders(List<RoutesBuilder> list) {
        Map beans = this.applicationContext.getBeansOfType(RoutesBuilder.class, true, true);
        Iterator i$ = beans.entrySet().iterator();
        while (i$.hasNext()) {
            Map.Entry object;
            Map.Entry entry = object = i$.next();
            Object bean = entry.getValue();
            Object key = entry.getKey();
            if (LOG.isTraceEnabled()) {
                LOG.trace("Found RouteBuilder with id: " + key + " -> " + bean);
            }
            if (this.shouldIgnoreBean(bean)) {
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug("Ignoring RouteBuilder id: " + key);
                continue;
            }
            if (!this.isFilteredClass(bean)) {
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug("Ignoring filtered RouteBuilder id: " + key + " as class: " + bean.getClass());
                continue;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Adding instantiated RouteBuilder id: " + key + " as class: " + bean.getClass());
            }
            list.add((RoutesBuilder)bean);
        }
    }

    protected boolean shouldIgnoreBean(Object bean) {
        return false;
    }

    protected boolean isFilteredClass(Object bean) {
        if (this.filter != null) {
            return this.filter.matches(bean.getClass());
        }
        return false;
    }
}

