/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.ssh;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.KeyPair;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.ssh.ResourceHelperKeyPairProvider;
import org.apache.camel.component.ssh.SshComponent;
import org.apache.camel.component.ssh.SshConfiguration;
import org.apache.camel.component.ssh.SshConsumer;
import org.apache.camel.component.ssh.SshProducer;
import org.apache.camel.component.ssh.SshResult;
import org.apache.camel.impl.ScheduledPollEndpoint;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.sshd.ClientChannel;
import org.apache.sshd.ClientSession;
import org.apache.sshd.SshClient;
import org.apache.sshd.client.future.AuthFuture;
import org.apache.sshd.client.future.ConnectFuture;
import org.apache.sshd.client.future.OpenFuture;
import org.apache.sshd.common.KeyPairProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@UriEndpoint(scheme="ssh", consumerClass=SshConsumer.class)
public class SshEndpoint
extends ScheduledPollEndpoint {
    protected final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private SshClient client;
    @UriParam
    private SshConfiguration sshConfiguration;

    public SshEndpoint() {
    }

    public SshEndpoint(String uri, SshComponent component) {
        super(uri, (Component)component);
    }

    public SshEndpoint(String uri, SshComponent component, SshConfiguration configuration) {
        super(uri, (Component)component);
        this.sshConfiguration = configuration;
    }

    public Producer createProducer() throws Exception {
        return new SshProducer(this);
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        SshConsumer consumer = new SshConsumer(this, processor);
        this.configureConsumer((Consumer)consumer);
        return consumer;
    }

    public boolean isSingleton() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SshResult sendExecCommand(String command) throws Exception {
        SshResult result = null;
        if (this.getConfiguration() == null) {
            throw new IllegalStateException("Configuration must be set");
        }
        ConnectFuture connectFuture = this.client.connect(this.getHost(), this.getPort());
        connectFuture.await(this.getTimeout());
        if (!connectFuture.isDone() || !connectFuture.isConnected()) {
            String msg = "Failed to connect to " + this.getHost() + ":" + this.getPort() + " within timeout " + this.getTimeout() + "ms";
            this.log.debug(msg);
            throw new RuntimeCamelException(msg);
        }
        this.log.debug("Connected to {}:{}", (Object)this.getHost(), (Object)this.getPort());
        ClientChannel channel = null;
        ClientSession session = null;
        try {
            AuthFuture authResult;
            Object keyPairProvider;
            session = connectFuture.getSession();
            String certResource = this.getCertResource();
            if (certResource != null) {
                this.log.debug("Attempting to authenticate using ResourceKey '{}'...", (Object)certResource);
                keyPairProvider = new ResourceHelperKeyPairProvider(new String[]{certResource}, this.getCamelContext().getClassResolver());
            } else {
                keyPairProvider = this.getKeyPairProvider();
            }
            if (keyPairProvider != null) {
                this.log.debug("Attempting to authenticate username '{}' using Key...", (Object)this.getUsername());
                KeyPair pair = keyPairProvider.loadKey(this.getKeyType());
                authResult = session.authPublicKey(this.getUsername(), pair);
            } else {
                this.log.debug("Attempting to authenticate username '{}' using Password...", (Object)this.getUsername());
                authResult = session.authPassword(this.getUsername(), this.getPassword());
            }
            authResult.await(this.getTimeout());
            if (!authResult.isDone() || authResult.isFailure()) {
                this.log.debug("Failed to authenticate");
                throw new RuntimeCamelException("Failed to authenticate username " + this.getUsername());
            }
            channel = session.createChannel("exec", command);
            ByteArrayInputStream in = new ByteArrayInputStream(new byte[]{0});
            channel.setIn((InputStream)in);
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            channel.setOut((OutputStream)out);
            ByteArrayOutputStream err = new ByteArrayOutputStream();
            channel.setErr((OutputStream)err);
            OpenFuture openFuture = channel.open();
            openFuture.await(this.getTimeout());
            if (openFuture.isOpened()) {
                channel.waitFor(2, 0L);
                result = new SshResult(command, channel.getExitStatus(), new ByteArrayInputStream(out.toByteArray()), new ByteArrayInputStream(err.toByteArray()));
            }
            SshResult sshResult = result;
            return sshResult;
        }
        finally {
            if (channel != null) {
                channel.close(true);
            }
            if (session != null) {
                session.close(false);
            }
        }
    }

    protected void doStart() throws Exception {
        super.doStart();
        this.client = SshClient.setUpDefaultClient();
        this.client.start();
    }

    protected void doStop() throws Exception {
        if (this.client != null) {
            this.client.stop();
            this.client = null;
        }
        super.doStop();
    }

    public SshConfiguration getConfiguration() {
        return this.sshConfiguration;
    }

    public void setConfiguration(SshConfiguration configuration) {
        this.sshConfiguration = configuration;
    }

    public String getHost() {
        return this.getConfiguration().getHost();
    }

    public void setHost(String host) {
        this.getConfiguration().setHost(host);
    }

    public int getPort() {
        return this.getConfiguration().getPort();
    }

    public void setPort(int port) {
        this.getConfiguration().setPort(port);
    }

    public String getUsername() {
        return this.getConfiguration().getUsername();
    }

    public void setUsername(String username) {
        this.getConfiguration().setUsername(username);
    }

    public String getPassword() {
        return this.getConfiguration().getPassword();
    }

    public void setPassword(String password) {
        this.getConfiguration().setPassword(password);
    }

    public String getPollCommand() {
        return this.getConfiguration().getPollCommand();
    }

    public void setPollCommand(String pollCommand) {
        this.getConfiguration().setPollCommand(pollCommand);
    }

    public KeyPairProvider getKeyPairProvider() {
        return this.getConfiguration().getKeyPairProvider();
    }

    public void setKeyPairProvider(KeyPairProvider keyPairProvider) {
        this.getConfiguration().setKeyPairProvider(keyPairProvider);
    }

    public String getKeyType() {
        return this.getConfiguration().getKeyType();
    }

    public void setKeyType(String keyType) {
        this.getConfiguration().setKeyType(keyType);
    }

    public long getTimeout() {
        return this.getConfiguration().getTimeout();
    }

    public void setTimeout(long timeout) {
        this.getConfiguration().setTimeout(timeout);
    }

    public String getCertFilename() {
        return this.getConfiguration().getCertFilename();
    }

    public void setCertFilename(String certFilename) {
        this.getConfiguration().setCertFilename(certFilename);
    }

    public String getCertResource() {
        return this.getConfiguration().getCertResource();
    }

    public void setCertResource(String certResource) {
        this.getConfiguration().setCertResource(certResource);
    }
}

