/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.stomp;

import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.component.stomp.StompEndpoint;
import org.apache.camel.impl.DefaultConsumer;
import org.fusesource.hawtbuf.AsciiBuffer;

public class StompConsumer
extends DefaultConsumer {
    AsciiBuffer id = this.getEndpoint().getNextId();

    public StompConsumer(Endpoint endpoint, Processor processor) {
        super(endpoint, processor);
    }

    public StompEndpoint getEndpoint() {
        return (StompEndpoint)super.getEndpoint();
    }

    protected void doStart() throws Exception {
        this.getEndpoint().addConsumer(this);
        super.doStart();
    }

    protected void doStop() throws Exception {
        this.getEndpoint().removeConsumer(this);
        super.doStop();
    }

    void processExchange(Exchange exchange) {
        try {
            this.getProcessor().process(exchange);
        }
        catch (Throwable e) {
            exchange.setException(e);
        }
        if (exchange.getException() != null) {
            this.getExceptionHandler().handleException("Error processing exchange.", exchange, (Throwable)exchange.getException());
        }
    }
}

