/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.stomp;

import java.util.Map;
import org.apache.camel.Endpoint;
import org.apache.camel.component.stomp.StompConfiguration;
import org.apache.camel.component.stomp.StompEndpoint;
import org.apache.camel.impl.UriEndpointComponent;

public class StompComponent
extends UriEndpointComponent {
    private StompConfiguration configuration = new StompConfiguration();

    public StompComponent() {
        super(StompEndpoint.class);
    }

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        String destination = "/" + remaining.replaceAll(":", "/");
        StompConfiguration config = this.getConfiguration().copy();
        this.setProperties(config, parameters);
        StompEndpoint endpoint = new StompEndpoint(uri, this, config, destination);
        this.setProperties((Object)endpoint, parameters);
        return endpoint;
    }

    public StompConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(StompConfiguration configuration) {
        this.configuration = configuration;
    }

    public void setBrokerURL(String brokerURL) {
        this.getConfiguration().setBrokerURL(brokerURL);
    }

    public void setLogin(String login) {
        this.getConfiguration().setLogin(login);
    }

    public void setPasscode(String passcode) {
        this.getConfiguration().setPasscode(passcode);
    }
}

