/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.syslog;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Map;
import org.apache.camel.Converter;
import org.apache.camel.component.syslog.SyslogFacility;
import org.apache.camel.component.syslog.SyslogMessage;
import org.apache.camel.component.syslog.SyslogSeverity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Converter
public final class Rfc3164SyslogConverter {
    private static final transient Logger LOG = LoggerFactory.getLogger(Rfc3164SyslogConverter.class);
    private static Map<String, MONTHS> monthValueMap = new HashMap<String, MONTHS>(){
        {
            this.put("jan", MONTHS.jan);
            this.put("feb", MONTHS.feb);
            this.put("mar", MONTHS.mar);
            this.put("apr", MONTHS.apr);
            this.put("may", MONTHS.may);
            this.put("jun", MONTHS.jun);
            this.put("jul", MONTHS.jul);
            this.put("aug", MONTHS.aug);
            this.put("sep", MONTHS.sep);
            this.put("oct", MONTHS.oct);
            this.put("nov", MONTHS.nov);
            this.put("dec", MONTHS.dec);
        }
    };

    private Rfc3164SyslogConverter() {
    }

    @Converter
    public static String toString(SyslogMessage message) {
        StringBuilder sbr = new StringBuilder();
        sbr.append("<");
        if (message.getFacility() == null) {
            message.setFacility(SyslogFacility.USER);
        }
        if (message.getSeverity() == null) {
            message.setSeverity(SyslogSeverity.INFO);
        }
        if (message.getHostname() == null) {
            try {
                message.setHostname(InetAddress.getLocalHost().toString());
            }
            catch (UnknownHostException e) {
                message.setHostname("UNKNOWN_HOST");
            }
        }
        sbr.append(message.getFacility().ordinal() * 8 + message.getSeverity().ordinal());
        sbr.append(">");
        if (message.getTimestamp() == null) {
            message.setTimestamp(new Date());
        }
        Calendar cal = GregorianCalendar.getInstance();
        cal.setTime(message.getTimestamp());
        String firstLetter = MONTHS.values()[cal.get(2)].toString().substring(0, 1);
        String remainder = MONTHS.values()[cal.get(2)].toString().substring(1);
        String capitalized = firstLetter.toUpperCase() + remainder.toLowerCase();
        sbr.append(capitalized);
        sbr.append(" ");
        if (cal.get(5) < 10) {
            sbr.append(" ").append(cal.get(5));
        } else {
            sbr.append(cal.get(5));
        }
        sbr.append(" ");
        if (cal.get(11) < 10) {
            sbr.append("0").append(cal.get(11));
        } else {
            sbr.append(cal.get(11));
        }
        sbr.append(":");
        if (cal.get(12) < 10) {
            sbr.append("0").append(cal.get(12));
        } else {
            sbr.append(cal.get(12));
        }
        sbr.append(":");
        if (cal.get(13) < 10) {
            sbr.append("0").append(cal.get(13));
        } else {
            sbr.append(cal.get(13));
        }
        sbr.append(" ");
        sbr.append(message.getHostname());
        sbr.append(" ");
        sbr.append(message.getLogMessage());
        return sbr.toString();
    }

    @Converter
    public static SyslogMessage toSyslogMessage(String body) {
        return Rfc3164SyslogConverter.parseMessage(body.getBytes());
    }

    public static SyslogMessage parseMessage(byte[] bytes) {
        ByteBuffer byteBuffer = ByteBuffer.allocate(bytes.length);
        byteBuffer.put(bytes);
        byteBuffer.rewind();
        SyslogMessage syslogMessage = new SyslogMessage();
        Character charFound = Character.valueOf((char)byteBuffer.get());
        while (charFound.charValue() != '<') {
            charFound = Character.valueOf((char)byteBuffer.get());
        }
        char priChar = '\u0000';
        if (charFound.charValue() == '<') {
            int facility = 0;
            while (true) {
                char c = (char)(byteBuffer.get() & 0xFF);
                priChar = c;
                if (!Character.isDigit(c)) break;
                facility *= 10;
                facility += Character.digit(priChar, 10);
            }
            syslogMessage.setFacility(SyslogFacility.values()[facility >> 3]);
            syslogMessage.setSeverity(SyslogSeverity.values()[facility & 7]);
        }
        if (priChar != '>') {
            LOG.error("Invalid syslog message, missing a > in the Facility/Priority part");
        }
        char[] month = new char[3];
        for (int i = 0; i < 3; ++i) {
            month[i] = (char)(byteBuffer.get() & 0xFF);
        }
        charFound = Character.valueOf((char)byteBuffer.get());
        if (charFound.charValue() != ' ') {
            LOG.error("Invalid syslog message, missing a mandatory space after month");
        }
        charFound = Character.valueOf((char)(byteBuffer.get() & 0xFF));
        int day = 0;
        if (charFound.charValue() != ' ') {
            day *= 10;
            day += Character.digit(charFound.charValue(), 10);
        }
        while (Character.isDigit((charFound = Character.valueOf((char)(byteBuffer.get() & 0xFF))).charValue())) {
            day *= 10;
            day += Character.digit(charFound.charValue(), 10);
        }
        int hour = 0;
        while (Character.isDigit((charFound = Character.valueOf((char)(byteBuffer.get() & 0xFF))).charValue())) {
            hour *= 10;
            hour += Character.digit(charFound.charValue(), 10);
        }
        int minute = 0;
        while (Character.isDigit((charFound = Character.valueOf((char)(byteBuffer.get() & 0xFF))).charValue())) {
            minute *= 10;
            minute += Character.digit(charFound.charValue(), 10);
        }
        int second = 0;
        while (Character.isDigit((charFound = Character.valueOf((char)(byteBuffer.get() & 0xFF))).charValue())) {
            second *= 10;
            second += Character.digit(charFound.charValue(), 10);
        }
        StringBuilder host = new StringBuilder();
        while ((charFound = Character.valueOf((char)(byteBuffer.get() & 0xFF))).charValue() != ' ') {
            host.append(charFound);
        }
        syslogMessage.setHostname(host.toString());
        StringBuilder msg = new StringBuilder();
        while (byteBuffer.hasRemaining()) {
            charFound = Character.valueOf((char)(byteBuffer.get() & 0xFF));
            msg.append(charFound);
        }
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.set(2, monthValueMap.get(String.valueOf(month).toLowerCase()).ordinal());
        calendar.set(5, day);
        calendar.set(11, hour);
        calendar.set(12, minute);
        calendar.set(13, second);
        syslogMessage.setTimestamp(calendar.getTime());
        syslogMessage.setLogMessage(msg.toString());
        LOG.trace("Syslog message : {}", (Object)syslogMessage.toString());
        return syslogMessage;
    }

    private static enum MONTHS {
        jan,
        feb,
        mar,
        apr,
        may,
        jun,
        jul,
        aug,
        sep,
        oct,
        nov,
        dec;

    }
}

