/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.test.blueprint;

import de.kalpatec.pojosr.framework.PojoServiceRegistryFactoryImpl;
import de.kalpatec.pojosr.framework.launch.BundleDescriptor;
import de.kalpatec.pojosr.framework.launch.ClasspathScanner;
import de.kalpatec.pojosr.framework.launch.PojoServiceRegistry;
import de.kalpatec.pojosr.framework.launch.PojoServiceRegistryFactory;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.jar.JarInputStream;
import org.apache.camel.impl.DefaultClassResolver;
import org.apache.camel.spi.ClassResolver;
import org.apache.camel.test.junit4.TestSupport;
import org.apache.camel.util.FileUtil;
import org.apache.camel.util.IOHelper;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.ResourceHelper;
import org.ops4j.pax.swissbox.tinybundles.core.TinyBundle;
import org.ops4j.pax.swissbox.tinybundles.core.TinyBundles;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.Filter;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CamelBlueprintHelper {
    public static final long DEFAULT_TIMEOUT = 30000L;
    public static final String BUNDLE_FILTER = "(Bundle-SymbolicName=*)";
    public static final String BUNDLE_VERSION = "1.0.0";
    private static final transient Logger LOG = LoggerFactory.getLogger(CamelBlueprintHelper.class);
    private static final ClassResolver RESOLVER = new DefaultClassResolver();

    private CamelBlueprintHelper() {
    }

    public static BundleContext createBundleContext(String name, String descriptors, boolean includeTestBundle) throws Exception {
        return CamelBlueprintHelper.createBundleContext(name, descriptors, includeTestBundle, BUNDLE_FILTER, BUNDLE_VERSION);
    }

    public static BundleContext createBundleContext(String name, String descriptors, boolean includeTestBundle, String bundleFilter, String testBundleVersion) throws Exception {
        TinyBundle bundle = null;
        if (includeTestBundle) {
            bundle = CamelBlueprintHelper.createTestBundle(name, testBundleVersion, descriptors);
        }
        return CamelBlueprintHelper.createBundleContext(name, bundleFilter, bundle);
    }

    public static BundleContext createBundleContext(String name, String bundleFilter, TinyBundle bundle) throws Exception {
        String uid = "" + System.currentTimeMillis();
        String tempDir = "target/bundles/" + uid;
        System.setProperty("org.osgi.framework.storage", tempDir);
        TestSupport.createDirectory((String)tempDir);
        TestSupport.createDirectory((String)"target/test-bundles");
        List<BundleDescriptor> bundles = CamelBlueprintHelper.getBundleDescriptors(bundleFilter);
        if (bundle != null) {
            String jarName = name.toLowerCase(Locale.ENGLISH) + "-" + uid + ".jar";
            bundles.add(CamelBlueprintHelper.getBundleDescriptor("target/test-bundles/" + jarName, bundle));
        }
        if (LOG.isDebugEnabled()) {
            for (int i = 0; i < bundles.size(); ++i) {
                BundleDescriptor desc = bundles.get(i);
                LOG.debug("Bundle #{} -> {}", (Object)i, (Object)desc);
            }
        }
        HashMap<String, List<BundleDescriptor>> config = new HashMap<String, List<BundleDescriptor>>();
        config.put(PojoServiceRegistryFactory.BUNDLE_DESCRIPTORS, bundles);
        PojoServiceRegistry reg = new PojoServiceRegistryFactoryImpl().newPojoServiceRegistry(config);
        return reg.getBundleContext();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void disposeBundleContext(BundleContext bundleContext) throws BundleException {
        try {
            if (bundleContext != null) {
                ArrayList<Bundle> bundles = new ArrayList<Bundle>();
                bundles.addAll(Arrays.asList(bundleContext.getBundles()));
                Collections.reverse(bundles);
                for (Bundle bundle : bundles) {
                    LOG.debug("Stopping bundle {}", (Object)bundle);
                    bundle.stop();
                }
            }
        }
        catch (Exception e) {
            LOG.warn("Error during disposing BundleContext. This exception will be ignored.", (Throwable)e);
        }
        finally {
            String tempDir = System.clearProperty("org.osgi.framework.storage");
            if (tempDir != null) {
                LOG.info("Deleting work directory {}", (Object)tempDir);
                TestSupport.deleteDirectory((String)tempDir);
            }
        }
    }

    public static <T> T getOsgiService(BundleContext bundleContext, Class<T> type, long timeout) {
        return CamelBlueprintHelper.getOsgiService(bundleContext, type, null, timeout);
    }

    public static <T> T getOsgiService(BundleContext bundleContext, Class<T> type) {
        return CamelBlueprintHelper.getOsgiService(bundleContext, type, null, 30000L);
    }

    public static <T> T getOsgiService(BundleContext bundleContext, Class<T> type, String filter) {
        return CamelBlueprintHelper.getOsgiService(bundleContext, type, filter, 30000L);
    }

    public static <T> T getOsgiService(BundleContext bundleContext, Class<T> type, String filter, long timeout) {
        ServiceTracker tracker = null;
        try {
            String flt = filter != null ? (filter.startsWith("(") ? "(&(objectClass=" + type.getName() + ")" + filter + ")" : "(&(objectClass=" + type.getName() + ")(" + filter + "))") : "(objectClass=" + type.getName() + ")";
            Filter osgiFilter = FrameworkUtil.createFilter((String)flt);
            tracker = new ServiceTracker(bundleContext, osgiFilter, null);
            tracker.open(true);
            Object svc = tracker.waitForService(timeout);
            if (svc == null) {
                Dictionary dic = bundleContext.getBundle().getHeaders();
                System.err.println("Test bundle headers: " + CamelBlueprintHelper.explode(dic));
                for (ServiceReference ref : CamelBlueprintHelper.asCollection(bundleContext.getAllServiceReferences(null, null))) {
                    System.err.println("ServiceReference: " + ref + ", bundle: " + ref.getBundle() + ", symbolicName: " + ref.getBundle().getSymbolicName());
                }
                for (ServiceReference ref : CamelBlueprintHelper.asCollection(bundleContext.getAllServiceReferences(null, flt))) {
                    System.err.println("Filtered ServiceReference: " + ref + ", bundle: " + ref.getBundle() + ", symbolicName: " + ref.getBundle().getSymbolicName());
                }
                throw new RuntimeException("Gave up waiting for service " + flt);
            }
            return type.cast(svc);
        }
        catch (InvalidSyntaxException e) {
            throw new IllegalArgumentException("Invalid filter", e);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    protected static TinyBundle createTestBundle(String name, String version, String descriptors) throws FileNotFoundException, MalformedURLException {
        TinyBundle bundle = TinyBundles.newBundle();
        for (URL url : CamelBlueprintHelper.getBlueprintDescriptors(descriptors)) {
            LOG.info("Using Blueprint XML file: " + url.getFile());
            bundle.add("OSGI-INF/blueprint/blueprint-" + url.getFile().replace("/", "-"), url);
        }
        bundle.set("Manifest-Version", "2").set("Bundle-ManifestVersion", "2").set("Bundle-SymbolicName", name).set("Bundle-Version", version);
        return bundle;
    }

    private static String explode(Dictionary<?, ?> dictionary) {
        Enumeration<?> keys = dictionary.keys();
        StringBuffer result = new StringBuffer();
        while (keys.hasMoreElements()) {
            Object key = keys.nextElement();
            result.append(String.format("%s=%s", key, dictionary.get(key)));
            if (!keys.hasMoreElements()) continue;
            result.append(", ");
        }
        return result.toString();
    }

    private static Collection<ServiceReference> asCollection(ServiceReference[] references) {
        return references == null ? new ArrayList(0) : Arrays.asList(references);
    }

    private static List<BundleDescriptor> getBundleDescriptors(String bundleFilter) throws Exception {
        return new ClasspathScanner().scanForBundles(bundleFilter);
    }

    private static Collection<URL> getBlueprintDescriptors(String descriptors) throws FileNotFoundException, MalformedURLException {
        ArrayList<URL> answer = new ArrayList<URL>();
        String descriptor = descriptors;
        if (descriptor != null) {
            Iterator it = ObjectHelper.createIterator((Object)descriptor);
            while (it.hasNext()) {
                String s = (String)it.next();
                LOG.trace("Resource descriptor: {}", (Object)s);
                s = FileUtil.stripLeadingSeparator((String)s);
                if (s.endsWith("*.xml")) {
                    String packageName = s.substring(0, s.length() - 5);
                    Enumeration urls = ObjectHelper.loadResourcesAsURL((String)packageName);
                    while (urls.hasMoreElements()) {
                        File[] files;
                        URL url = (URL)urls.nextElement();
                        File dir = new File(url.getFile());
                        if (!dir.isDirectory() || (files = dir.listFiles()) == null) continue;
                        for (File file : files) {
                            if (!file.isFile() || !file.exists() || !file.getName().endsWith(".xml")) continue;
                            String name = packageName + file.getName();
                            LOG.debug("Resolving resource: {}", (Object)name);
                            URL xmlUrl = ObjectHelper.loadResourceAsURL((String)name);
                            if (xmlUrl == null) continue;
                            answer.add(xmlUrl);
                        }
                    }
                    continue;
                }
                LOG.debug("Resolving resource: {}", (Object)s);
                URL url = ResourceHelper.resolveMandatoryResourceAsUrl((ClassResolver)RESOLVER, (String)s);
                if (url == null) {
                    throw new FileNotFoundException("Resource " + s + " not found");
                }
                answer.add(url);
            }
        } else {
            throw new IllegalArgumentException("No bundle descriptor configured. Override getBlueprintDescriptor() or getBlueprintDescriptors() method");
        }
        if (answer.isEmpty()) {
            throw new IllegalArgumentException("Cannot find any resources in classpath from descriptor " + descriptors);
        }
        return answer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static BundleDescriptor getBundleDescriptor(String path, TinyBundle bundle) throws Exception {
        File file = new File(path);
        file.deleteOnExit();
        FileOutputStream fos = new FileOutputStream(file, false);
        InputStream is = bundle.build();
        try {
            IOHelper.copyAndCloseInput((InputStream)is, (OutputStream)fos);
        }
        catch (Throwable throwable) {
            IOHelper.close((Closeable[])new Closeable[]{is, fos});
            throw throwable;
        }
        IOHelper.close((Closeable[])new Closeable[]{is, fos});
        BundleDescriptor answer = null;
        FileInputStream fis = null;
        JarInputStream jis = null;
        try {
            fis = new FileInputStream(file);
            jis = new JarInputStream(fis);
            HashMap<String, String> headers = new HashMap<String, String>();
            for (Map.Entry<Object, Object> entry : jis.getManifest().getMainAttributes().entrySet()) {
                headers.put(entry.getKey().toString(), entry.getValue().toString());
            }
            answer = new BundleDescriptor(bundle.getClass().getClassLoader(), new URL("jar:" + file.toURI().toString() + "!/"), headers);
        }
        catch (Throwable throwable) {
            IOHelper.close((Closeable[])new Closeable[]{jis, fis});
            throw throwable;
        }
        IOHelper.close((Closeable[])new Closeable[]{jis, fis});
        return answer;
    }
}

