/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.testng;

import java.io.InputStream;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.naming.Context;
import javax.naming.InitialContext;
import org.apache.camel.CamelContext;
import org.apache.camel.ConsumerTemplate;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.Message;
import org.apache.camel.Predicate;
import org.apache.camel.Processor;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.Service;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.impl.BreakpointSupport;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.impl.DefaultDebugger;
import org.apache.camel.impl.InterceptSendToMockEndpointStrategy;
import org.apache.camel.impl.JndiRegistry;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.spi.Breakpoint;
import org.apache.camel.spi.Debugger;
import org.apache.camel.spi.EndpointStrategy;
import org.apache.camel.spi.Language;
import org.apache.camel.spi.Registry;
import org.apache.camel.spring.CamelBeanPostProcessor;
import org.apache.camel.testng.TestSupport;
import org.apache.camel.util.StopWatch;
import org.apache.camel.util.TimeUtils;
import org.junit.AfterClass;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;

public abstract class CamelTestSupport
extends TestSupport {
    protected static volatile CamelContext context;
    protected static volatile ProducerTemplate template;
    protected static volatile ConsumerTemplate consumer;
    protected static volatile Service camelContextService;
    private static final Logger LOG;
    private static final AtomicBoolean INIT;
    private boolean useRouteBuilder = true;
    private final DebugBreakpoint breakpoint = new DebugBreakpoint();
    private final StopWatch watch = new StopWatch();

    public boolean isUseRouteBuilder() {
        return this.useRouteBuilder;
    }

    public void setUseRouteBuilder(boolean useRouteBuilder) {
        this.useRouteBuilder = useRouteBuilder;
    }

    public boolean isCreateCamelContextPerClass() {
        return false;
    }

    public String isMockEndpoints() {
        return null;
    }

    public Service getCamelContextService() {
        return camelContextService;
    }

    public void setCamelContextService(Service service) {
        camelContextService = service;
    }

    @BeforeMethod
    public void setUp() throws Exception {
        this.log.info("********************************************************************************");
        this.log.info("Testing: " + this.getTestMethodName() + "(" + ((Object)((Object)this)).getClass().getName() + ")");
        this.log.info("********************************************************************************");
        boolean first = INIT.compareAndSet(false, true);
        if (this.isCreateCamelContextPerClass()) {
            if (first) {
                this.doSetUp();
            } else {
                this.postProcessTest();
                this.resetMocks();
            }
        } else {
            this.doSetUp();
        }
        this.watch.restart();
    }

    protected void doSetUp() throws Exception {
        this.log.debug("setUp test");
        if (!this.useJmx()) {
            this.disableJMX();
        } else {
            this.enableJMX();
        }
        context = this.createCamelContext();
        CamelTestSupport.assertNotNull((Object)context, (String)"No context found!");
        context.getShutdownStrategy().setTimeout((long)this.getShutdownTimeout());
        context.setDebugger((Debugger)new DefaultDebugger());
        context.getDebugger().addBreakpoint((Breakpoint)this.breakpoint);
        template = context.createProducerTemplate();
        template.start();
        consumer = context.createConsumerTemplate();
        consumer.start();
        String pattern = this.isMockEndpoints();
        if (pattern != null) {
            context.addRegisterEndpointCallback((EndpointStrategy)new InterceptSendToMockEndpointStrategy(pattern));
        }
        this.postProcessTest();
        if (this.isUseRouteBuilder()) {
            RouteBuilder[] builders;
            for (RouteBuilder builder : builders = this.createRouteBuilders()) {
                this.log.debug("Using created route builder: " + builder);
                context.addRoutes((RoutesBuilder)builder);
            }
            if (!"true".equalsIgnoreCase(System.getProperty("skipStartingCamelContext"))) {
                this.startCamelContext();
            } else {
                this.log.info("Skipping starting CamelContext as system property skipStartingCamelContext is set to be true.");
            }
        } else {
            this.log.debug("Using route builder from the created context: " + context);
        }
        this.log.debug("Routing Rules are: " + context.getRoutes());
        this.assertValidContext(context);
        INIT.set(true);
    }

    @AfterMethod
    public void tearDown() throws Exception {
        long time = this.watch.stop();
        this.log.info("********************************************************************************");
        this.log.info("Testing done: " + this.getTestMethodName() + "(" + ((Object)((Object)this)).getClass().getName() + ")");
        this.log.info("Took: " + TimeUtils.printDuration((double)time) + " (" + time + " millis)");
        this.log.info("********************************************************************************");
        if (this.isCreateCamelContextPerClass()) {
            return;
        }
        this.log.debug("tearDown test");
        CamelTestSupport.doStopTemplates();
        this.stopCamelContext();
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        INIT.set(false);
        LOG.debug("tearDownAfterClass test");
        CamelTestSupport.doStopTemplates();
        CamelTestSupport.doStopCamelContext();
    }

    protected int getShutdownTimeout() {
        return 10;
    }

    protected boolean useJmx() {
        return false;
    }

    protected boolean isLazyLoadingTypeConverter() {
        return true;
    }

    protected void postProcessTest() throws Exception {
        CamelBeanPostProcessor processor = new CamelBeanPostProcessor();
        processor.setCamelContext(context);
        processor.postProcessBeforeInitialization((Object)this, "this");
    }

    protected void stopCamelContext() throws Exception {
        CamelTestSupport.doStopCamelContext();
    }

    private static void doStopCamelContext() throws Exception {
        if (camelContextService != null) {
            camelContextService.stop();
            camelContextService = null;
        } else if (context != null) {
            context.stop();
            context = null;
        }
    }

    private static void doStopTemplates() throws Exception {
        if (consumer != null) {
            consumer.stop();
            consumer = null;
        }
        if (template != null) {
            template.stop();
            template = null;
        }
    }

    public Service camelContextService() {
        return camelContextService;
    }

    public CamelContext context() {
        return context;
    }

    public ProducerTemplate template() {
        return template;
    }

    public ConsumerTemplate consumer() {
        return consumer;
    }

    protected void startCamelContext() throws Exception {
        if (camelContextService != null) {
            camelContextService.start();
        } else if (context instanceof DefaultCamelContext) {
            DefaultCamelContext defaultCamelContext = (DefaultCamelContext)context;
            if (!defaultCamelContext.isStarted()) {
                defaultCamelContext.start();
            }
        } else {
            context.start();
        }
    }

    protected CamelContext createCamelContext() throws Exception {
        DefaultCamelContext context = new DefaultCamelContext((Registry)this.createRegistry());
        context.setLazyLoadTypeConverters(Boolean.valueOf(this.isLazyLoadingTypeConverter()));
        return context;
    }

    protected JndiRegistry createRegistry() throws Exception {
        return new JndiRegistry(this.createJndiContext());
    }

    protected Context createJndiContext() throws Exception {
        Properties properties = new Properties();
        InputStream in = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("jndi.properties");
        if (in != null) {
            this.log.debug("Using jndi.properties from classpath root");
            properties.load(in);
        } else {
            properties.put("java.naming.factory.initial", "org.apache.camel.util.jndi.CamelInitialContextFactory");
        }
        return new InitialContext(new Hashtable<Object, Object>(properties));
    }

    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() {
            }
        };
    }

    protected RouteBuilder[] createRouteBuilders() throws Exception {
        return new RouteBuilder[]{this.createRouteBuilder()};
    }

    protected Endpoint resolveMandatoryEndpoint(String uri) {
        return CamelTestSupport.resolveMandatoryEndpoint(context, uri);
    }

    protected <T extends Endpoint> T resolveMandatoryEndpoint(String uri, Class<T> endpointType) {
        return CamelTestSupport.resolveMandatoryEndpoint(context, uri, endpointType);
    }

    protected MockEndpoint getMockEndpoint(String uri) {
        return this.resolveMandatoryEndpoint(uri, MockEndpoint.class);
    }

    protected void sendBody(String endpointUri, final Object body) {
        template.send(endpointUri, new Processor(){

            public void process(Exchange exchange) {
                Message in = exchange.getIn();
                in.setBody(body);
            }
        });
    }

    protected void sendBody(String endpointUri, final Object body, final Map<String, Object> headers) {
        template.send(endpointUri, new Processor(){

            public void process(Exchange exchange) {
                Message in = exchange.getIn();
                in.setBody(body);
                for (Map.Entry entry : headers.entrySet()) {
                    in.setHeader((String)entry.getKey(), entry.getValue());
                }
            }
        });
    }

    protected void sendBodies(String endpointUri, Object ... bodies) {
        for (Object body : bodies) {
            this.sendBody(endpointUri, body);
        }
    }

    protected Exchange createExchangeWithBody(Object body) {
        return this.createExchangeWithBody(context, body);
    }

    protected void assertExpression(Exchange exchange, String languageName, String expressionText, Object expectedValue) {
        Language language = this.assertResolveLanguage(languageName);
        Expression expression = language.createExpression(expressionText);
        CamelTestSupport.assertNotNull((Object)expression, (String)("No Expression could be created for text: " + expressionText + " language: " + language));
        CamelTestSupport.assertExpression(expression, exchange, expectedValue);
    }

    protected void assertPredicate(String languageName, String expressionText, Exchange exchange, boolean expected) {
        Language language = this.assertResolveLanguage(languageName);
        Predicate predicate = language.createPredicate(expressionText);
        CamelTestSupport.assertNotNull((Object)predicate, (String)("No Predicate could be created for text: " + expressionText + " language: " + language));
        CamelTestSupport.assertPredicate(predicate, exchange, expected);
    }

    protected Language assertResolveLanguage(String languageName) {
        Language language = context.resolveLanguage(languageName);
        CamelTestSupport.assertNotNull((Object)language, (String)("No language found for name: " + languageName));
        return language;
    }

    protected void assertMockEndpointsSatisfied() throws InterruptedException {
        MockEndpoint.assertIsSatisfied((CamelContext)context);
    }

    protected void assertMockEndpointsSatisfied(long timeout, TimeUnit unit) throws InterruptedException {
        MockEndpoint.assertIsSatisfied((CamelContext)context, (long)timeout, (TimeUnit)unit);
    }

    protected void resetMocks() {
        MockEndpoint.resetMocks((CamelContext)context);
    }

    protected void assertValidContext(CamelContext context) {
        CamelTestSupport.assertNotNull((Object)context, (String)"No context found!");
    }

    protected <T extends Endpoint> T getMandatoryEndpoint(String uri, Class<T> type) {
        Endpoint endpoint = context.getEndpoint(uri, type);
        CamelTestSupport.assertNotNull((Object)endpoint, (String)("No endpoint found for uri: " + uri));
        return (T)endpoint;
    }

    protected Endpoint getMandatoryEndpoint(String uri) {
        Endpoint endpoint = context.getEndpoint(uri);
        CamelTestSupport.assertNotNull((Object)endpoint, (String)("No endpoint found for uri: " + uri));
        return endpoint;
    }

    protected void disableJMX() {
        System.setProperty("org.apache.camel.jmx.disabled", "true");
    }

    protected void enableJMX() {
        System.setProperty("org.apache.camel.jmx.disabled", "false");
    }

    protected void debugBefore(Exchange exchange, Processor processor, ProcessorDefinition definition, String id, String label) {
    }

    protected void debugAfter(Exchange exchange, Processor processor, ProcessorDefinition definition, String id, String label, long timeTaken) {
    }

    static {
        LOG = LoggerFactory.getLogger(TestSupport.class);
        INIT = new AtomicBoolean();
    }

    private class DebugBreakpoint
    extends BreakpointSupport {
        private DebugBreakpoint() {
        }

        public void beforeProcess(Exchange exchange, Processor processor, ProcessorDefinition definition) {
            CamelTestSupport.this.debugBefore(exchange, processor, definition, definition.getId(), definition.getLabel());
        }

        public void afterProcess(Exchange exchange, Processor processor, ProcessorDefinition definition, long timeTaken) {
            CamelTestSupport.this.debugAfter(exchange, processor, definition, definition.getId(), definition.getLabel(), timeTaken);
        }
    }
}

