/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dataformat.univocity;

import com.univocity.parsers.common.AbstractParser;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import org.apache.camel.dataformat.univocity.HeaderRowProcessor;

final class Unmarshaller<P extends AbstractParser<?>> {
    private final boolean lazyLoad;
    private final boolean asMap;

    Unmarshaller(boolean lazyLoad, boolean asMap) {
        this.lazyLoad = lazyLoad;
        this.asMap = asMap;
    }

    public Object unmarshal(Reader reader, P parser, HeaderRowProcessor headerRowProcessor) {
        parser.beginParsing(reader);
        RowIterator iterator = this.asMap ? new MapRowIterator<P>(parser, headerRowProcessor) : new ListRowIterator<P>(parser);
        return this.lazyLoad ? iterator : Unmarshaller.convertToList(iterator);
    }

    private static <T> List<T> convertToList(Iterator<T> iterator) {
        ArrayList<T> result = new ArrayList<T>();
        while (iterator.hasNext()) {
            result.add(iterator.next());
        }
        return result;
    }

    private static class MapRowIterator<P extends AbstractParser<?>>
    extends RowIterator<Map<String, String>, P> {
        private final HeaderRowProcessor headerRowProcessor;

        protected MapRowIterator(P parser, HeaderRowProcessor headerRowProcessor) {
            super(parser);
            this.headerRowProcessor = headerRowProcessor;
        }

        @Override
        protected Map<String, String> convertRow(String[] row) {
            String[] headers = this.headerRowProcessor.getHeaders();
            int size = Math.min(row.length, headers.length);
            LinkedHashMap<String, String> result = new LinkedHashMap<String, String>(size);
            for (int i = 0; i < size; ++i) {
                result.put(headers[i], row[i]);
            }
            return result;
        }
    }

    private static final class ListRowIterator<P extends AbstractParser<?>>
    extends RowIterator<List<String>, P> {
        protected ListRowIterator(P parser) {
            super(parser);
        }

        @Override
        protected List<String> convertRow(String[] row) {
            return Arrays.asList(row);
        }
    }

    private static abstract class RowIterator<E, P extends AbstractParser<?>>
    implements Iterator<E> {
        private final P parser;
        private String[] row;

        protected RowIterator(P parser) {
            this.parser = parser;
            this.row = this.parser.parseNext();
        }

        @Override
        public final boolean hasNext() {
            return this.row != null;
        }

        @Override
        public final E next() {
            if (this.row == null) {
                throw new NoSuchElementException();
            }
            E result = this.convertRow(this.row);
            this.row = this.parser.parseNext();
            return result;
        }

        @Override
        public final void remove() {
            throw new UnsupportedOperationException();
        }

        protected abstract E convertRow(String[] var1);
    }
}

